/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestStoreAccess {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Test
    public void openingThroughStoreAccessShouldNotTriggerRecovery() throws Exception {
        EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore();
        Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean(snapshot));
        File messages = new File(this.storeDir, "messages.log");
        snapshot.deleteFile(messages);
        PageCache pageCache = this.pageCacheRule.getPageCache(snapshot);
        new StoreAccess((FileSystemAbstraction)snapshot, pageCache, this.storeDir).initialize().close();
        Assert.assertTrue((String)"Store should be unclean", (boolean)this.isUnclean(snapshot));
    }

    private EphemeralFileSystemAbstraction produceUncleanStore() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(this.storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        EphemeralFileSystemAbstraction snapshot = this.fs.get().snapshot();
        db.shutdown();
        return snapshot;
    }

    private boolean isUnclean(FileSystemAbstraction fileSystem) throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystem);
        return new RecoveryRequiredChecker(fileSystem, pageCache).isRecoveryRequiredAt(this.storeDir);
    }
}

