/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;

public class ConfigMapUpgradeConfigurationTestIT {
    @Test
    public void shouldNotAllowAutomaticUpgradeIfConfigParameterIsMissing() {
        Config config = MigrationTestUtils.defaultConfig();
        Assert.assertFalse((boolean)((Boolean)config.get(GraphDatabaseSettings.allow_store_upgrade)));
        try {
            new ConfigMapUpgradeConfiguration(config).checkConfigurationAllowsAutomaticUpgrade();
            Assert.fail((String)"Should throw exception");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowAutomaticUpgradeIfConfigParameterIsFalse() {
        Config config = MigrationTestUtils.defaultConfig(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.allow_store_upgrade.name(), "false"}));
        try {
            new ConfigMapUpgradeConfiguration(config).checkConfigurationAllowsAutomaticUpgrade();
            Assert.fail((String)"Should throw exception");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAllowAutomaticUpgradeIfConfigParameterIsTrue() {
        Config config = MigrationTestUtils.defaultConfig(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.allow_store_upgrade.name(), "false"}));
        try {
            new ConfigMapUpgradeConfiguration(config).checkConfigurationAllowsAutomaticUpgrade();
            Assert.fail((String)"Should throw exception");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
    }
}

