/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;

public class RelationshipGroupGetterTest {
    @Test
    public void shouldAbortLoadingGroupChainIfComeTooFar() throws Exception {
        RelationshipGroupStore store = (RelationshipGroupStore)Mockito.mock(RelationshipGroupStore.class);
        RelationshipGroupGetter groupGetter = new RelationshipGroupGetter(store);
        RelationshipGroupRecord group_2 = new RelationshipGroupRecord(0L, 2);
        RelationshipGroupRecord group_4 = new RelationshipGroupRecord(1L, 4);
        RelationshipGroupRecord group_10 = new RelationshipGroupRecord(2L, 10);
        RelationshipGroupRecord group_23 = new RelationshipGroupRecord(3L, 23);
        this.linkAndMock(store, group_2, group_4, group_10, group_23);
        NodeRecord node = new NodeRecord(0L, true, group_2.getId(), -1L);
        DirectRecordAccess access = new DirectRecordAccess((AbstractRecordStore)store, Loaders.relationshipGroupLoader((RelationshipGroupStore)store));
        RelationshipGroupGetter.RelationshipGroupPosition result = groupGetter.getRelationshipGroup(node, 7, (RecordAccess)access);
        InOrder verification = Mockito.inOrder((Object[])new Object[]{store});
        ((RelationshipGroupStore)verification.verify((Object)store)).getRecord(group_2.getId());
        ((RelationshipGroupStore)verification.verify((Object)store)).getRecord(group_4.getId());
        ((RelationshipGroupStore)verification.verify((Object)store)).getRecord(group_10.getId());
        verification.verifyNoMoreInteractions();
        Assert.assertNull((Object)result.group());
        Assert.assertEquals((Object)group_4, (Object)result.closestPrevious().forReadingData());
    }

    private void linkAndMock(RelationshipGroupStore store, RelationshipGroupRecord ... groups) {
        for (int i = 0; i < groups.length; ++i) {
            Mockito.when((Object)store.getRecord(groups[i].getId())).thenReturn((Object)groups[i]);
            if (i > 0) {
                groups[i].setPrev(groups[i - 1].getId());
            }
            if (i >= groups.length - 1) continue;
            groups[i].setNext(groups[i + 1].getId());
        }
    }
}

