/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestTraversalWithIterable
extends TraversalTestBase {
    @Test
    public void traverseWithIterableForStartNodes() throws Exception {
        this.createGraph("a TO b", "b TO c", "d TO e", "e TO f");
        try (Transaction tx = this.beginTx();){
            TraversalDescription basicTraverser = this.getGraphDb().traversalDescription().evaluator(Evaluators.atDepth((int)2));
            ArrayList<Node> startNodes = new ArrayList<Node>();
            startNodes.add(this.getNodeWithName("a"));
            startNodes.add(this.getNodeWithName("d"));
            ArrayList<Node> iterableStartNodes = startNodes;
            this.expectPaths(basicTraverser.traverse(iterableStartNodes), "a,b,c", "d,e,f");
            tx.success();
        }
    }

    @Test
    public void useTraverserInsideTraverser() throws Exception {
        this.createGraph("a FIRST d", "a TO b", "b TO c", "d TO e", "e TO f");
        try (Transaction tx = this.beginTx();){
            TraversalDescription firstTraverser = this.getGraphDb().traversalDescription().relationships((RelationshipType)DynamicRelationshipType.withName((String)"FIRST")).evaluator(Evaluators.toDepth((int)1));
            Traverser firstResult = firstTraverser.traverse(this.getNodeWithName("a"));
            IterableWrapper<Node, Path> startNodesForNestedTraversal = new IterableWrapper<Node, Path>((Iterable)firstResult){

                protected Node underlyingObjectToObject(Path path) {
                    return path.endNode();
                }
            };
            TraversalDescription nestedTraversal = this.getGraphDb().traversalDescription().evaluator(Evaluators.atDepth((int)2));
            this.expectPaths(nestedTraversal.traverse((Iterable)startNodesForNestedTraversal), "a,b,c", "d,e,f");
            tx.success();
        }
    }
}

