/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.qa.tooling;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.qa.tooling.DumpProcessInformation;
import org.neo4j.qa.tooling.DumpableProcess;
import org.neo4j.test.TargetDirectory;

public class DumpProcessInformationTest {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private static final String SIGNAL = "here";

    @Test
    public void shouldDumpProcessInformation() throws Exception {
        File directory = this.testDirectory.directory("dump");
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), DumpableProcess.class.getName(), SIGNAL});
        this.awaitSignal(process);
        DumpProcessInformation dumper = new DumpProcessInformation(NullLogProvider.getInstance(), directory);
        Collection<Pair<Long, String>> pids = dumper.getJPids((Matcher<String>)Matchers.containsString((String)DumpableProcess.class.getSimpleName()));
        Assume.assumeThat((Object)pids.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Pair pid = (Pair)IteratorUtil.single(pids);
        File threaddumpFile = dumper.doThreadDump((Pair<Long, String>)pid);
        process.destroy();
        Assert.assertTrue((boolean)this.fileContains(threaddumpFile, "traceableMethod", DumpableProcess.class.getName()));
    }

    private boolean fileContains(File file, String ... expectedStrings) {
        Set expectedStringSet = IteratorUtil.asSet((Object[])expectedStrings);
        for (String line : IteratorUtil.asIterable((File)file, (String)"UTF-8")) {
            Iterator expectedStringIterator = expectedStringSet.iterator();
            while (expectedStringIterator.hasNext()) {
                if (!line.contains((CharSequence)expectedStringIterator.next())) continue;
                expectedStringIterator.remove();
            }
        }
        return expectedStringSet.isEmpty();
    }

    private void awaitSignal(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            if (!SIGNAL.equals(line)) {
                Assert.fail((String)("Got weird signal " + line));
            }
        }
    }
}

