/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.test.ExternalResource;

public class PageCacheRule
extends ExternalResource {
    private PageCache pageCache;
    private final boolean automaticallyProduceInconsistentReads;

    public PageCacheRule() {
        this.automaticallyProduceInconsistentReads = true;
    }

    public PageCacheRule(boolean automaticallyProduceInconsistentReads) {
        this.automaticallyProduceInconsistentReads = automaticallyProduceInconsistentReads;
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(GraphDatabaseSettings.pagecache_memory.name(), "8M");
        return this.getPageCache(fs, new Config(settings));
    }

    public PageCache getPageCache(FileSystemAbstraction fs, Config config) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (IOException e) {
                throw new AssertionError("Failed to stop existing PageCache prior to creating a new one", e);
            }
        }
        this.pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (Config)config);
        if (this.automaticallyProduceInconsistentReads) {
            return this.withInconsistentReads(this.pageCache);
        }
        return this.pageCache;
    }

    @Override
    protected void after(boolean success) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (IOException e) {
                throw new AssertionError("Failed to stop PageCache after test", e);
            }
            this.pageCache = null;
        }
    }

    public PageCache withInconsistentReads(PageCache pageCache, AtomicBoolean nextReadIsInconsistent) {
        AtomicInconsistentReadDecision decision = new AtomicInconsistentReadDecision(nextReadIsInconsistent);
        return new PossiblyInconsistentPageCache(pageCache, decision);
    }

    public PageCache withInconsistentReads(PageCache pageCache) {
        RandomInconsistentReadDecision decision = new RandomInconsistentReadDecision();
        return new PossiblyInconsistentPageCache(pageCache, decision);
    }

    private static class PossiblyInconsistentPageCursor
    implements PageCursor {
        private final PageCursor cursor;
        private final InconsistentReadDecision decision;
        private boolean currentReadIsInconsistent;

        public PossiblyInconsistentPageCursor(PageCursor cursor, InconsistentReadDecision decision) {
            this.cursor = cursor;
            this.decision = decision;
        }

        @Override
        public byte getByte() {
            return this.currentReadIsInconsistent ? (byte)0 : this.cursor.getByte();
        }

        @Override
        public byte getByte(int offset) {
            return this.currentReadIsInconsistent ? (byte)0 : this.cursor.getByte(offset);
        }

        @Override
        public void putByte(byte value) {
            this.cursor.putByte(value);
        }

        @Override
        public void putByte(int offset, byte value) {
            this.cursor.putByte(offset, value);
        }

        @Override
        public long getLong() {
            return this.currentReadIsInconsistent ? 0L : this.cursor.getLong();
        }

        @Override
        public long getLong(int offset) {
            return this.currentReadIsInconsistent ? 0L : this.cursor.getLong(offset);
        }

        @Override
        public void putLong(long value) {
            this.cursor.putLong(value);
        }

        @Override
        public void putLong(int offset, long value) {
            this.cursor.putLong(offset, value);
        }

        @Override
        public int getInt() {
            return this.currentReadIsInconsistent ? 0 : this.cursor.getInt();
        }

        @Override
        public int getInt(int offset) {
            return this.currentReadIsInconsistent ? 0 : this.cursor.getInt(offset);
        }

        @Override
        public void putInt(int value) {
            this.cursor.putInt(value);
        }

        @Override
        public void putInt(int offset, int value) {
            this.cursor.putInt(offset, value);
        }

        @Override
        public long getUnsignedInt() {
            return this.currentReadIsInconsistent ? 0L : this.cursor.getUnsignedInt();
        }

        @Override
        public long getUnsignedInt(int offset) {
            return this.currentReadIsInconsistent ? 0L : this.cursor.getUnsignedInt(offset);
        }

        @Override
        public void getBytes(byte[] data) {
            if (!this.currentReadIsInconsistent) {
                this.cursor.getBytes(data);
            }
        }

        @Override
        public void getBytes(byte[] data, int arrayOffset, int length) {
            if (!this.currentReadIsInconsistent) {
                this.cursor.getBytes(data, arrayOffset, length);
            }
        }

        @Override
        public void putBytes(byte[] data) {
            this.cursor.putBytes(data);
        }

        @Override
        public void putBytes(byte[] data, int arrayOffset, int length) {
            this.cursor.putBytes(data, arrayOffset, length);
        }

        @Override
        public short getShort() {
            return this.currentReadIsInconsistent ? (short)0 : this.cursor.getShort();
        }

        @Override
        public short getShort(int offset) {
            return this.currentReadIsInconsistent ? (short)0 : this.cursor.getShort(offset);
        }

        @Override
        public void putShort(short value) {
            this.cursor.putShort(value);
        }

        @Override
        public void putShort(int offset, short value) {
            this.cursor.putShort(offset, value);
        }

        @Override
        public void setOffset(int offset) {
            this.cursor.setOffset(offset);
        }

        @Override
        public int getOffset() {
            return this.cursor.getOffset();
        }

        @Override
        public long getCurrentPageId() {
            return this.cursor.getCurrentPageId();
        }

        @Override
        public int getCurrentPageSize() {
            return this.cursor.getCurrentPageSize();
        }

        @Override
        public File getCurrentFile() {
            return this.cursor.getCurrentFile();
        }

        @Override
        public void rewind() throws IOException {
            this.cursor.rewind();
        }

        @Override
        public boolean next() throws IOException {
            this.currentReadIsInconsistent = this.decision.isNextReadInconsistent();
            return this.cursor.next();
        }

        @Override
        public boolean next(long pageId) throws IOException {
            this.currentReadIsInconsistent = this.decision.isNextReadInconsistent();
            return this.cursor.next(pageId);
        }

        @Override
        public void close() {
            this.cursor.close();
        }

        @Override
        public boolean shouldRetry() throws IOException {
            if (this.currentReadIsInconsistent) {
                this.currentReadIsInconsistent = false;
                this.cursor.shouldRetry();
                this.cursor.setOffset(0);
                return true;
            }
            return this.cursor.shouldRetry();
        }
    }

    private static class PossiblyInconsistentPagedFile
    implements PagedFile {
        private final PagedFile pagedFile;
        private final InconsistentReadDecision decision;

        public PossiblyInconsistentPagedFile(PagedFile pagedFile, InconsistentReadDecision decision) {
            this.pagedFile = pagedFile;
            this.decision = decision;
        }

        public String toString() {
            return "PossiblyInconsistent:" + this.pagedFile;
        }

        @Override
        public PageCursor io(long pageId, int pf_flags) throws IOException {
            PageCursor cursor = this.pagedFile.io(pageId, pf_flags);
            if ((pf_flags & 1) == 1) {
                return new PossiblyInconsistentPageCursor(cursor, this.decision);
            }
            return cursor;
        }

        @Override
        public int pageSize() {
            return this.pagedFile.pageSize();
        }

        @Override
        public void flushAndForce() throws IOException {
            this.pagedFile.flushAndForce();
        }

        @Override
        public long getLastPageId() throws IOException {
            return this.pagedFile.getLastPageId();
        }

        @Override
        public void close() throws IOException {
            this.pagedFile.close();
        }
    }

    private static class PossiblyInconsistentPageCache
    implements PageCache {
        private final PageCache pageCache;
        private final InconsistentReadDecision decision;

        public PossiblyInconsistentPageCache(PageCache pageCache, InconsistentReadDecision decision) {
            this.pageCache = pageCache;
            this.decision = decision;
        }

        @Override
        public PagedFile map(File file, int pageSize, OpenOption ... openOptions) throws IOException {
            PagedFile pagedFile = this.pageCache.map(file, pageSize, openOptions);
            return new PossiblyInconsistentPagedFile(pagedFile, this.decision);
        }

        @Override
        public void flushAndForce() throws IOException {
            this.pageCache.flushAndForce();
        }

        @Override
        public void close() throws IOException {
            this.pageCache.close();
        }

        @Override
        public int pageSize() {
            return this.pageCache.pageSize();
        }

        @Override
        public int maxCachedPages() {
            return this.pageCache.maxCachedPages();
        }
    }

    private static class RandomInconsistentReadDecision
    implements InconsistentReadDecision {
        private RandomInconsistentReadDecision() {
        }

        @Override
        public boolean isNextReadInconsistent() {
            return ThreadLocalRandom.current().nextBoolean();
        }
    }

    private static class AtomicInconsistentReadDecision
    implements InconsistentReadDecision {
        private final AtomicBoolean nextReadIsInconsistent;

        public AtomicInconsistentReadDecision(AtomicBoolean nextReadIsInconsistent) {
            this.nextReadIsInconsistent = nextReadIsInconsistent;
        }

        @Override
        public boolean isNextReadInconsistent() {
            return this.nextReadIsInconsistent.getAndSet(false);
        }
    }

    private static interface InconsistentReadDecision {
        public boolean isNextReadInconsistent();
    }
}

