/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Random;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.helpers.Exceptions;
import org.neo4j.test.Randoms;

public class RandomRule
implements TestRule {
    private Long specificSeed;
    private long seed;
    private Random random;
    private Randoms randoms;

    public RandomRule withSeed(long seed) {
        this.specificSeed = seed;
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RandomRule.this.seed = RandomRule.this.specificSeed == null ? System.currentTimeMillis() : RandomRule.this.specificSeed;
                RandomRule.this.reset();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    throw Exceptions.withMessage((Throwable)t, (String)(t.getMessage() + ": random seed used:" + RandomRule.this.seed));
                }
            }
        };
    }

    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public int intBetween(int min, int max) {
        return this.randoms.intBetween(min, max);
    }

    public String string() {
        return this.randoms.string();
    }

    public String string(int minLength, int maxLength, int characterSets) {
        return this.randoms.string(minLength, maxLength, characterSets);
    }

    public char character(int characterSets) {
        return this.randoms.character(characterSets);
    }

    public <T> T[] selection(T[] among, int min, int max, boolean allowDuplicates) {
        return this.randoms.selection(among, min, max, allowDuplicates);
    }

    public <T> T among(T[] among) {
        return this.randoms.among(among);
    }

    public Object propertyValue() {
        return this.randoms.propertyValue();
    }

    public void reset() {
        this.random = new Random(this.seed);
        this.randoms = new Randoms(this.random, Randoms.DEFAULT);
    }

    public Randoms fork(Randoms.Configuration configuration) {
        return this.randoms.fork(configuration);
    }

    public long seed() {
        return this.seed;
    }

    public Random random() {
        return this.random;
    }

    public Randoms randoms() {
        return this.randoms;
    }
}

