/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.docs;

import java.io.File;
import java.io.PrintWriter;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.io.fs.FileUtils;

public class DocsIncludeFile
implements TestRule {
    private final String section;
    private PrintWriter writer;

    public static DocsIncludeFile inSection(String section) {
        return new DocsIncludeFile(section);
    }

    public void printf(String format, Object ... parameters) {
        this.writer.printf(format, parameters);
    }

    public void println(String line) {
        this.writer.println(line);
    }

    public void println() {
        this.writer.println();
    }

    DocsIncludeFile(String section) {
        this.section = section;
    }

    public Statement apply(final Statement base, Description description) {
        String methodName = description.getMethodName();
        Assert.assertNotNull((String)(DocsIncludeFile.class.getName() + " must be a non-static @Rule"), (Object)methodName);
        File dir = FileUtils.path("target", "docs", this.section, "includes");
        Assert.assertTrue((String)(dir + " must be a directory"), (dir.isDirectory() || dir.mkdirs() ? 1 : 0) != 0);
        final File file = FileUtils.path(dir, methodName + ".asciidoc");
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (file.exists()) {
                    Assert.assertTrue((String)(file + " should not exist"), (file.isFile() && file.delete() ? 1 : 0) != 0);
                }
                DocsIncludeFile.this.writer = new PrintWriter(file);
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        DocsIncludeFile.this.writer.close();
                    }
                    finally {
                        DocsIncludeFile.this.writer = null;
                    }
                }
            }
        };
    }
}

