/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.tooling.GlobalGraphOperations;

public class GlobalGraphOperationsIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldListAllPropertyKeys() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            db.createNode().setProperty("myProperty", (Object)12);
            tx.success();
        }
        GlobalGraphOperations gg = GlobalGraphOperations.at((GraphDatabaseService)db);
        try (Transaction _ = db.beginTx();){
            MatcherAssert.assertThat((Object)Iterables.toList((Iterable)gg.getAllPropertyKeys()), (Matcher)Matchers.equalTo(Arrays.asList("myProperty")));
        }
    }

    @Test
    public void shouldReturnAllLabels() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        Label dead = DynamicLabel.label((String)"dead");
        Label alive = DynamicLabel.label((String)"alive");
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{alive});
            db.createNode(new Label[]{dead});
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            Node node = (Node)IteratorUtil.single((Iterator)db.findNodes(dead));
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        GlobalGraphOperations gg = GlobalGraphOperations.at((GraphDatabaseService)db);
        try (Transaction ignored = db.beginTx();){
            MatcherAssert.assertThat((Object)Iterables.toSet((Iterable)gg.getAllLabels()), (Matcher)Matchers.equalTo((Object)Iterables.toSet(Arrays.asList(alive, dead))));
        }
    }

    @Test
    public void shouldReturnAllInUseLabels() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        Label dead = DynamicLabel.label((String)"dead");
        Label alive = DynamicLabel.label((String)"alive");
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{alive});
            db.createNode(new Label[]{dead});
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            Node node = (Node)IteratorUtil.single((Iterator)db.findNodes(dead));
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        GlobalGraphOperations gg = GlobalGraphOperations.at((GraphDatabaseService)db);
        try (Transaction ignored = db.beginTx();){
            MatcherAssert.assertThat((Object)Iterables.toSet((Iterable)gg.getAllLabelsInUse()), (Matcher)Matchers.equalTo(Collections.singleton(alive)));
        }
    }

    @Test
    public void shouldReturnAllRelationshipTypes() {
        long deadId;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        DynamicRelationshipType dead = DynamicRelationshipType.withName((String)"DEAD");
        DynamicRelationshipType alive = DynamicRelationshipType.withName((String)"ALIVE");
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)alive);
            deadId = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)dead).getId();
            tx.success();
        }
        tx = db.beginTx();
        var7_5 = null;
        try {
            db.getRelationshipById(deadId).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        GlobalGraphOperations gg = GlobalGraphOperations.at((GraphDatabaseService)db);
        try (Transaction ignored = db.beginTx();){
            Iterable result = Iterables.map((Function)new Function<RelationshipType, String>(){

                @Override
                public String apply(RelationshipType relationshipType) {
                    return relationshipType.name();
                }
            }, (Iterable)gg.getAllRelationshipTypes());
            MatcherAssert.assertThat((Object)Iterables.toSet((Iterable)result), (Matcher)Matchers.equalTo((Object)Iterables.toSet(Arrays.asList(alive.name(), dead.name()))));
        }
    }

    @Test
    public void shouldReturnAllInUseRelationshipTypes() {
        long deadId;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        DynamicRelationshipType dead = DynamicRelationshipType.withName((String)"DEAD");
        DynamicRelationshipType alive = DynamicRelationshipType.withName((String)"ALIVE");
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)alive);
            deadId = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)dead).getId();
            tx.success();
        }
        tx = db.beginTx();
        var7_5 = null;
        try {
            db.getRelationshipById(deadId).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        GlobalGraphOperations gg = GlobalGraphOperations.at((GraphDatabaseService)db);
        try (Transaction ignored = db.beginTx();){
            Iterable result = Iterables.map((Function)new Function<RelationshipType, String>(){

                @Override
                public String apply(RelationshipType relationshipType) {
                    return relationshipType.name();
                }
            }, (Iterable)gg.getAllRelationshipTypesInUse());
            MatcherAssert.assertThat((Object)Iterables.toSet((Iterable)result), (Matcher)Matchers.equalTo(Collections.singleton(alive.name())));
        }
    }
}

