/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicIntArrayTest {
    @Test
    public void shouldWorkOnSingleChunk() throws Exception {
        int defaultValue = 0;
        IntArray array = NumberArrayFactory.AUTO.newDynamicIntArray(10L, defaultValue);
        array.set(4L, 5);
        Assert.assertEquals((long)5L, (long)array.get(4L));
        Assert.assertEquals((long)defaultValue, (long)array.get(12L));
        array.set(7L, 1324);
        Assert.assertEquals((long)1324L, (long)array.get(7L));
    }

    @Test
    public void shouldChunksAsNeeded() throws Exception {
        IntArray array = NumberArrayFactory.AUTO.newDynamicIntArray(10L, 0);
        long index = 243L;
        int value = 5485748;
        array.set(index, value);
        Assert.assertEquals((long)value, (long)array.get(index));
    }

    @Test
    public void shouldFixate() throws Exception {
        IntArray array = NumberArrayFactory.AUTO.newDynamicIntArray(100L, 0);
        array.set(50L, 1);
        array.set(500L, 1);
        array = array.fixate();
        Assert.assertEquals((long)1L, (long)array.get(50L));
        Assert.assertEquals((long)1L, (long)array.get(500L));
        array.set(499L, 10);
        Assert.assertEquals((long)10L, (long)array.get(499L));
        Assert.assertEquals((long)0L, (long)array.get(50000L));
        try {
            array.set(650L, 9);
            Assert.fail((String)"Should have been fixated at this point");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

