/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;

public class LongBitsManipulatorTest {
    @Test
    public void shouldManageTwoSlots() throws Exception {
        LongBitsManipulator manipulator = new LongBitsManipulator(new int[]{35, 29});
        long field = 0L;
        field = manipulator.set(field, 0, 10L);
        field = manipulator.set(field, 1, 13L);
        Assert.assertEquals((long)10L, (long)manipulator.get(field, 0));
        Assert.assertEquals((long)13L, (long)manipulator.get(field, 1));
    }

    @Test
    public void shouldInterpretAllOnesAsMinusOne() throws Exception {
        LongBitsManipulator manipulator = new LongBitsManipulator(new int[]{35, 29});
        long field = manipulator.template(new boolean[]{true, false});
        Assert.assertEquals((long)-1L, (long)manipulator.get(field, 0));
    }

    @Test
    public void shouldHandleMinusOneValues() throws Exception {
        LongBitsManipulator manipulator = new LongBitsManipulator(new int[]{1, 5, 10, 16, 32});
        long field = 0L;
        for (int i = 0; i < 5; ++i) {
            int j;
            for (j = 0; j < 5; ++j) {
                long valueAfterClearWouldHaveChangedIt;
                if (j == i) {
                    valueAfterClearWouldHaveChangedIt = manipulator.clear(field, j, true);
                    field = manipulator.set(field, j, -1L);
                    Assert.assertEquals((String)("Clear(true) and set -1 produced different results for i:" + i + ", j:" + j), (long)field, (long)valueAfterClearWouldHaveChangedIt);
                    continue;
                }
                valueAfterClearWouldHaveChangedIt = manipulator.clear(field, j, false);
                field = manipulator.set(field, j, 0L);
                Assert.assertEquals((String)("Clear(false) and set 0 produced different results for i:" + i + ", j:" + j), (long)field, (long)valueAfterClearWouldHaveChangedIt);
            }
            for (j = 0; j < 5; ++j) {
                long value = manipulator.get(field, j);
                if (j == i) {
                    Assert.assertEquals((long)-1L, (long)value);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)value);
            }
        }
    }
}

