/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.SoyModule;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

class MainClassUtils {
    private MainClassUtils() {
    }

    public static CmdLineParser parseFlags(Object object, String[] stringArray, String string) {
        CmdLineParser cmdLineParser = new CmdLineParser(object);
        cmdLineParser.setUsageWidth(100);
        try {
            cmdLineParser.parseArgument(stringArray);
        }
        catch (CmdLineException cmdLineException) {
            MainClassUtils.exitWithError(cmdLineException.getMessage(), cmdLineParser, string);
        }
        return cmdLineParser;
    }

    public static void exitWithError(String string, CmdLineParser cmdLineParser, String string2) {
        System.err.println("\nError: " + string + "\n\n");
        System.err.println(string2);
        cmdLineParser.printUsage((OutputStream)System.err);
        System.exit(1);
    }

    public static Injector createInjector(String string, @Nullable String string2) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)2);
        arrayList.add(new SoyModule());
        Preconditions.checkArgument((string != null && string.length() > 0 ? 1 : 0) != 0);
        arrayList.add(MainClassUtils.instantiatePluginModule(string));
        if (string2 != null && string2.length() > 0) {
            for (String string3 : Splitter.on((char)',').split((CharSequence)string2)) {
                arrayList.add(MainClassUtils.instantiatePluginModule(string3));
            }
        }
        return Guice.createInjector((Iterable)arrayList);
    }

    private static Module instantiatePluginModule(String string) {
        try {
            return (Module)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Cannot find plugin module \"" + string + "\".", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot access plugin module \"" + string + "\".", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Cannot instantiate plugin module \"" + string + "\".", instantiationException);
        }
    }

    public static class StringListOptionHandler
    extends ListOptionHandler<String> {
        public StringListOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super String> setter) {
            super(cmdLineParser, optionDef, setter);
        }

        @Override
        public String parseItem(String string) {
            return string;
        }
    }

    public static abstract class ListOptionHandler<T>
    extends OptionHandler<T> {
        public ListOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super T> setter) {
            super(cmdLineParser, optionDef, setter);
        }

        public abstract T parseItem(String var1);

        public int parseArguments(Parameters parameters) throws CmdLineException {
            for (String string : parameters.getParameter(0).split(",")) {
                this.setter.addValue(this.parseItem(string));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "ITEM,ITEM,...";
        }
    }

    public static class BooleanOptionHandler
    extends OptionHandler<Boolean> {
        public BooleanOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super Boolean> setter) {
            super(cmdLineParser, optionDef, setter);
        }

        public int parseArguments(Parameters parameters) throws CmdLineException {
            boolean bl;
            boolean bl2;
            try {
                String string = parameters.getParameter(0);
                if (string.equals("true") || string.equals("1")) {
                    bl2 = true;
                    bl = true;
                } else if (string.equals("false") || string.equals("0")) {
                    bl2 = false;
                    bl = true;
                } else {
                    bl2 = true;
                    bl = false;
                }
            }
            catch (CmdLineException cmdLineException) {
                bl2 = true;
                bl = false;
            }
            this.setter.addValue((Object)bl2);
            return bl ? 1 : 0;
        }

        public String getDefaultMetaVariable() {
            return null;
        }
    }
}

