/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;

public class BaseUtils {
    private static final Set<String> KNOWN_EXISTING_DIRS = Sets.newHashSet();
    private static final String IDENT_RE = "[a-zA-Z_][a-zA-Z_0-9]*";
    private static final Pattern IDENT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    private static final Pattern IDENT_WITH_LEADING_DOT_PATTERN = Pattern.compile("[.][a-zA-Z_][a-zA-Z_0-9]*");
    public static final String DOTTED_IDENT_RE = "[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*";
    private static final Pattern DOTTED_IDENT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*");
    private static final Pattern LEADING_OR_TRAILING_UNDERSCORE_PATTERN = Pattern.compile("^_+|_+\\Z");
    private static final Pattern WORD_BOUNDARY_IN_IDENT_PATTERN = Pattern.compile("(?<= [a-zA-Z])(?= [A-Z][a-z])| (?<= [a-zA-Z])(?= [0-9])| (?<= [0-9])(?= [a-zA-Z])", 4);
    private static final Pattern CONSECUTIVE_UNDERSCORES_PATTERN = Pattern.compile("_ _ _*", 4);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private BaseUtils() {
    }

    public static void ensureDirsExistInPath(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            throw new AssertionError((Object)"ensureDirsExistInPath called with null or empty path.");
        }
        String string3 = string2 = string.charAt(string.length() - 1) == File.separatorChar ? string.substring(0, string.length() - 1) : new File(string).getParent();
        if (string2 == null || KNOWN_EXISTING_DIRS.contains(string2)) {
            return;
        }
        new File(string2).mkdirs();
        KNOWN_EXISTING_DIRS.add(string2);
    }

    public static boolean isIdentifier(String string) {
        return IDENT_PATTERN.matcher(string).matches();
    }

    public static boolean isIdentifierWithLeadingDot(String string) {
        return IDENT_WITH_LEADING_DOT_PATTERN.matcher(string).matches();
    }

    public static boolean isDottedIdentifier(String string) {
        return DOTTED_IDENT_PATTERN.matcher(string).matches();
    }

    public static String convertToUpperUnderscore(String string) {
        string = LEADING_OR_TRAILING_UNDERSCORE_PATTERN.matcher(string).replaceAll("");
        string = WORD_BOUNDARY_IN_IDENT_PATTERN.matcher(string).replaceAll("_");
        string = CONSECUTIVE_UNDERSCORES_PATTERN.matcher(string).replaceAll("_");
        return string.toUpperCase();
    }

    public static String escapeToSoyString(String string, boolean bl) {
        int n;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 * 9 / 8);
        stringBuilder.append("'");
        block10: for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            switch (n) {
                case 10: {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case 13: {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case 9: {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case 8: {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case 12: {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case 92: {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case 39: {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case 34: {
                    stringBuilder.append("\"");
                    continue block10;
                }
                default: {
                    if (bl && (n < 32 || n >= 127)) {
                        BaseUtils.appendHexEscape(stringBuilder, n);
                        continue block10;
                    }
                    stringBuilder.appendCodePoint(n);
                }
            }
        }
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public static void appendHexEscape(StringBuilder stringBuilder, int n) {
        if (Character.isSupplementaryCodePoint(n)) {
            char[] cArray = Character.toChars(n);
            BaseUtils.appendHexEscape(stringBuilder, cArray[0]);
            BaseUtils.appendHexEscape(stringBuilder, cArray[1]);
        } else {
            stringBuilder.append("\\u").append(HEX_DIGITS[n >>> 12 & 0xF]).append(HEX_DIGITS[n >>> 8 & 0xF]).append(HEX_DIGITS[n >>> 4 & 0xF]).append(HEX_DIGITS[n & 0xF]);
        }
    }
}

