/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SourceLocation {
    @Nonnull
    private final String sourcePath;
    private final int lineNumber;
    public static final SourceLocation UNKNOWN = new SourceLocation("unknown", 0);

    public SourceLocation(String string, int n) {
        this.sourcePath = string;
        this.lineNumber = n;
    }

    @Nonnull
    public String getSourcePath() {
        return this.sourcePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isKnown() {
        return !this.equals(UNKNOWN);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SourceLocation)) {
            return false;
        }
        SourceLocation sourceLocation = (SourceLocation)object;
        return this.sourcePath.equals(sourceLocation.sourcePath) && this.lineNumber == sourceLocation.lineNumber;
    }

    public int hashCode() {
        return this.sourcePath.hashCode() + 31 * this.lineNumber;
    }

    public String toString() {
        return this.lineNumber != 0 ? this.sourcePath + ":" + this.lineNumber : this.sourcePath;
    }
}

