/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.template.soy.base.SourceLocation;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public class SoySyntaxException
extends RuntimeException {
    private SourceLocation sourceLocation = SourceLocation.UNKNOWN;
    private String templateName;

    public SoySyntaxException(String string) {
        super(string);
    }

    public SoySyntaxException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public SoySyntaxException(Throwable throwable) {
        super(throwable.getMessage(), throwable);
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Nullable
    public String getTemplateName() {
        return this.templateName;
    }

    public SoySyntaxException setFilePath(String string) {
        return this.setSourceLocation(new SourceLocation(string, 0));
    }

    public SoySyntaxException setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public SoySyntaxException setTemplateName(String string) {
        this.templateName = string;
        return this;
    }

    @Override
    public String getMessage() {
        boolean bl = this.sourceLocation.isKnown();
        boolean bl2 = this.templateName != null;
        String string = super.getMessage();
        if (bl) {
            if (bl2) {
                return "In file " + this.sourceLocation + ", template " + this.templateName + ": " + string;
            }
            return "In file " + this.sourceLocation + ": " + string;
        }
        if (bl2) {
            return "In template " + this.templateName + ": " + string;
        }
        return string;
    }
}

