/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.coredirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.EscapingConventions;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class EscapeHtmlDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    public static final String NAME = "|escapeHtml";

    @Inject
    public EscapeHtmlDirective() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return true;
    }

    @Override
    public String apply(SoyData soyData, List<SoyData> list) {
        SanitizedContent sanitizedContent;
        if (soyData instanceof SanitizedContent && (sanitizedContent = (SanitizedContent)soyData).getContentKind() == SanitizedContent.ContentKind.HTML) {
            return sanitizedContent.getContent();
        }
        return EscapingConventions.EscapeHtml.INSTANCE.escape(soyData.toString());
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        return new JsExpr("soy.$$escapeHtml(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr javaExpr, List<JavaExpr> list) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$escapeHtml", javaExpr.getText()), String.class, Integer.MAX_VALUE);
    }
}

