/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyData;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class SanitizedContent
extends SoyData {
    private final String content;
    private final ContentKind contentKind;

    public SanitizedContent(String string, ContentKind contentKind) {
        this.content = string;
        this.contentKind = contentKind;
    }

    public String getContent() {
        return this.content;
    }

    public ContentKind getContentKind() {
        return this.contentKind;
    }

    @Override
    public boolean toBoolean() {
        return this.content.length() != 0;
    }

    @Override
    public String toString() {
        return this.content;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object instanceof SanitizedContent && this.contentKind == ((SanitizedContent)object).contentKind && this.content.equals(((SanitizedContent)object).content);
    }

    public int hashCode() {
        return this.content.hashCode() + 31 * this.contentKind.hashCode();
    }

    public static enum ContentKind {
        HTML,
        JS_STR_CHARS,
        URI,
        HTML_ATTRIBUTE;

    }
}

