/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AugmentedSoyMapData
extends SoyMapData {
    private final SoyMapData baseData;

    public AugmentedSoyMapData(SoyMapData soyMapData) {
        Preconditions.checkNotNull((Object)soyMapData);
        this.baseData = soyMapData;
    }

    @Override
    public Map<String, SoyData> asMap() {
        SoyMapData soyMapData = new SoyMapData();
        AugmentedSoyMapData.addMapDataHelper(soyMapData, "", this.baseData.asMap());
        AugmentedSoyMapData.addMapDataHelper(soyMapData, "", super.asMap());
        return Collections.unmodifiableMap(soyMapData.asMap());
    }

    private static void addMapDataHelper(SoyMapData soyMapData, String string, Map<String, SoyData> map) {
        for (Map.Entry<String, SoyData> entry : map.entrySet()) {
            String string2 = entry.getKey();
            SoyData soyData = entry.getValue();
            if (soyData instanceof SoyMapData) {
                AugmentedSoyMapData.addMapDataHelper(soyMapData, string + string2 + ".", ((SoyMapData)soyData).asMap());
                continue;
            }
            if (soyData instanceof SoyListData) {
                AugmentedSoyMapData.addListDataHelper(soyMapData, string + string2 + ".", ((SoyListData)soyData).asList());
                continue;
            }
            soyMapData.put(string + string2, soyData);
        }
    }

    private static void addListDataHelper(SoyMapData soyMapData, String string, List<SoyData> list) {
        for (int i = 0; i < list.size(); ++i) {
            SoyData soyData = list.get(i);
            if (soyData instanceof SoyMapData) {
                AugmentedSoyMapData.addMapDataHelper(soyMapData, string + i + ".", ((SoyMapData)soyData).asMap());
                continue;
            }
            if (soyData instanceof SoyListData) {
                AugmentedSoyMapData.addListDataHelper(soyMapData, string + i + ".", ((SoyListData)soyData).asList());
                continue;
            }
            soyMapData.put(string + i, soyData);
        }
    }

    @Override
    public Set<String> getKeys() {
        return Collections.unmodifiableSet(Sets.union(super.getKeys(), this.baseData.getKeys()));
    }

    @Override
    public String toString() {
        return this.toStringHelper(this.asMap());
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public void put(String string, SoyData soyData) {
        if (string.indexOf(46) >= 0) {
            throw new SoyDataException("Attempted to put multi-part key string into AugmentedSoyMapData. Please ensure that all of your 'param' commands only use top-level keys.");
        }
        super.putSingle(string, soyData);
    }

    @Override
    public void remove(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSingle(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SoyData get(String string) {
        SoyData soyData = super.get(string);
        if (soyData != null) {
            return soyData;
        }
        return this.baseData.get(string);
    }

    @Override
    public SoyData getSingle(String string) {
        SoyData soyData = super.getSingle(string);
        if (soyData != null) {
            return soyData;
        }
        return this.baseData.getSingle(string);
    }
}

