/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.common.collect.Lists;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import java.util.ArrayList;
import java.util.List;

public abstract class CollectionData
extends SoyData {
    public void put(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new SoyDataException("Varargs to put(...) must have an even number of arguments (key-value pairs).");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            try {
                this.put((String)objectArray[i], SoyData.createFromExistingData(objectArray[i + 1]));
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new SoyDataException("Attempting to add a mapping containing a non-string key (key type " + objectArray[i].getClass().getName() + ").");
            }
        }
    }

    public void put(String string, SoyData soyData) {
        List<String> list = CollectionData.split(string, '.');
        int n = list.size();
        CollectionData collectionData = this;
        for (int i = 0; i <= n - 2; ++i) {
            SoyData soyData2 = collectionData.getSingle(list.get(i));
            if (soyData2 != null && !(soyData2 instanceof CollectionData)) {
                throw new SoyDataException("Failed to evaluate key string \"" + string + "\" for put().");
            }
            CollectionData collectionData2 = (CollectionData)soyData2;
            if (collectionData2 == null) {
                collectionData2 = Character.isDigit(list.get(i + 1).charAt(0)) ? new SoyListData() : new SoyMapData();
                collectionData.putSingle(list.get(i), collectionData2);
            }
            collectionData = collectionData2;
        }
        collectionData.putSingle(list.get(n - 1), CollectionData.ensureValidValue(soyData));
    }

    public void put(String string, boolean bl) {
        this.put(string, BooleanData.forValue(bl));
    }

    public void put(String string, int n) {
        this.put(string, IntegerData.forValue(n));
    }

    public void put(String string, double d) {
        this.put(string, FloatData.forValue(d));
    }

    public void put(String string, String string2) {
        this.put(string, StringData.forValue(string2));
    }

    public void remove(String string) {
        List<String> list = CollectionData.split(string, '.');
        int n = list.size();
        CollectionData collectionData = this;
        for (int i = 0; i <= n - 2; ++i) {
            SoyData soyData = collectionData.getSingle(list.get(i));
            if (soyData == null || !(soyData instanceof CollectionData)) {
                return;
            }
            collectionData = (CollectionData)soyData;
        }
        collectionData.removeSingle(list.get(n - 1));
    }

    public SoyData get(String string) {
        List<String> list = CollectionData.split(string, '.');
        int n = list.size();
        CollectionData collectionData = this;
        for (int i = 0; i <= n - 2; ++i) {
            SoyData soyData = collectionData.getSingle(list.get(i));
            if (soyData == null || !(soyData instanceof CollectionData)) {
                return null;
            }
            collectionData = (CollectionData)soyData;
        }
        return collectionData.getSingle(list.get(n - 1));
    }

    public SoyMapData getMapData(String string) {
        return (SoyMapData)this.get(string);
    }

    public SoyListData getListData(String string) {
        return (SoyListData)this.get(string);
    }

    public boolean getBoolean(String string) {
        SoyData soyData = this.get(string);
        if (soyData == null) {
            throw new IllegalArgumentException("Missing key: " + string);
        }
        return soyData.booleanValue();
    }

    public int getInteger(String string) {
        SoyData soyData = this.get(string);
        if (soyData == null) {
            throw new IllegalArgumentException("Missing key: " + string);
        }
        return soyData.integerValue();
    }

    public double getFloat(String string) {
        SoyData soyData = this.get(string);
        if (soyData == null) {
            throw new IllegalArgumentException("Missing key: " + string);
        }
        return soyData.floatValue();
    }

    public String getString(String string) {
        SoyData soyData = this.get(string);
        if (soyData == null) {
            throw new IllegalArgumentException("Missing key: " + string);
        }
        return soyData.stringValue();
    }

    public abstract void putSingle(String var1, SoyData var2);

    public abstract void removeSingle(String var1);

    public abstract SoyData getSingle(String var1);

    protected static SoyData ensureValidValue(SoyData soyData) {
        return soyData != null ? soyData : NullData.INSTANCE;
    }

    private static List<String> split(String string, char c) {
        ArrayList arrayList = Lists.newArrayList();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(c, n)) == -1) break;
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }
}

