/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.template.soy.data.restricted.NumberData;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IntegerData
extends NumberData {
    public static final IntegerData ZERO = new IntegerData(0);
    public static final IntegerData ONE = new IntegerData(1);
    public static final IntegerData MINUS_ONE = new IntegerData(-1);
    private static final IntegerData TWO = new IntegerData(2);
    private static final IntegerData THREE = new IntegerData(3);
    private static final IntegerData FOUR = new IntegerData(4);
    private static final IntegerData FIVE = new IntegerData(5);
    private static final IntegerData SIX = new IntegerData(6);
    private static final IntegerData SEVEN = new IntegerData(7);
    private static final IntegerData EIGHT = new IntegerData(8);
    private static final IntegerData NINE = new IntegerData(9);
    private static final IntegerData TEN = new IntegerData(10);
    private final int value;

    @Deprecated
    public IntegerData(int n) {
        this.value = n;
    }

    public static IntegerData forValue(int n) {
        switch (n) {
            case -1: {
                return MINUS_ONE;
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
            case 9: {
                return NINE;
            }
            case 10: {
                return TEN;
            }
        }
        return new IntegerData(n);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int integerValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public boolean toBoolean() {
        return this.value != 0;
    }

    @Override
    public double toFloat() {
        return this.value;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof NumberData)) {
            return false;
        }
        if (object instanceof IntegerData) {
            return this.value == ((IntegerData)object).getValue();
        }
        return super.equals(object);
    }
}

