/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.restricted.PrimitiveData;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StringData
extends PrimitiveData {
    public static final StringData EMPTY_STRING = new StringData("");
    private final String value;

    @Deprecated
    public StringData(String string) {
        Preconditions.checkNotNull((Object)string);
        this.value = string;
    }

    public static StringData forValue(String string) {
        return string.length() == 0 ? EMPTY_STRING : new StringData(string);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean toBoolean() {
        return this.value.length() > 0;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object.getClass() == StringData.class && ((StringData)object).getValue().equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

