/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.template.soy.exprparse.ExpressionParserConstants;
import com.google.template.soy.exprparse.ExpressionParserTokenManager;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.SimpleCharStream;
import com.google.template.soy.exprparse.Token;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.internal.base.UnescapeUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ExpressionParser
implements ExpressionParserConstants {
    public ExpressionParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ExpressionParser(String string) {
        this(new StringReader(string));
    }

    public List<ExprRootNode<?>> parseExpressionList() throws TokenMgrError, ParseException {
        return this.ExprListInput();
    }

    public ExprRootNode<?> parseExpression() throws TokenMgrError, ParseException {
        return this.ExprInput();
    }

    public ExprRootNode<VarNode> parseVariable() throws TokenMgrError, ParseException {
        return this.VarInput();
    }

    public ExprRootNode<DataRefNode> parseDataReference() throws TokenMgrError, ParseException {
        return this.DataRefInput();
    }

    public ExprRootNode<GlobalNode> parseGlobal() throws TokenMgrError, ParseException {
        return this.GlobalInput();
    }

    private static final ExprNode.OperatorNode createOperatorNode(String string, int n) {
        try {
            return Operator.of(string, n).getNodeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
            return null;
        }
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode abstractPrimitiveNode;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                abstractPrimitiveNode = new NullNode();
                break;
            }
            case 2: {
                Token token = this.jj_consume_token(2);
                abstractPrimitiveNode = new BooleanNode(token.image.equals("true"));
                break;
            }
            case 3: {
                Token token = this.jj_consume_token(3);
                if (token.image.startsWith("0x")) {
                    abstractPrimitiveNode = new IntegerNode(Integer.parseInt(token.image.substring(2), 16));
                    break;
                }
                abstractPrimitiveNode = new IntegerNode(Integer.parseInt(token.image, 10));
                break;
            }
            case 4: {
                Token token = this.jj_consume_token(4);
                abstractPrimitiveNode = new FloatNode(Double.parseDouble(token.image));
                break;
            }
            case 5: {
                Token token = this.jj_consume_token(5);
                String string = token.image.substring(1, token.image.length() - 1);
                abstractPrimitiveNode = new StringNode(UnescapeUtils.unescapeJs(string));
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return abstractPrimitiveNode;
    }

    private final String UnaryOp() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            case 8: {
                token = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final String BinaryOp() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                token = this.jj_consume_token(10);
                break;
            }
            case 8: {
                token = this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    private final List<ExprRootNode<?>> ExprListInput() throws ParseException {
        List<ExprNode> list = this.ExprList();
        ArrayList arrayList = Lists.newArrayList();
        for (ExprNode exprNode : list) {
            arrayList.add(new ExprRootNode<ExprNode>(exprNode));
        }
        this.jj_consume_token(0);
        return arrayList;
    }

    private final ExprRootNode<?> ExprInput() throws ParseException {
        ExprNode exprNode = this.Expr();
        this.jj_consume_token(0);
        return new ExprRootNode<ExprNode>(exprNode);
    }

    private final ExprRootNode<VarNode> VarInput() throws ParseException {
        VarNode varNode = this.Var();
        this.jj_consume_token(0);
        return new ExprRootNode<VarNode>(varNode);
    }

    private final ExprRootNode<DataRefNode> DataRefInput() throws ParseException {
        DataRefNode dataRefNode = this.DataRef();
        this.jj_consume_token(0);
        return new ExprRootNode<DataRefNode>(dataRefNode);
    }

    private final ExprRootNode<GlobalNode> GlobalInput() throws ParseException {
        GlobalNode globalNode = this.Global();
        this.jj_consume_token(0);
        return new ExprRootNode<GlobalNode>(globalNode);
    }

    private final List<ExprNode> ExprList() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        ExprNode exprNode = this.Expr();
        arrayList.add(exprNode);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(16);
            exprNode = this.Expr();
            arrayList.add(exprNode);
        }
        return arrayList;
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode exprNode = this.PrecExpr1();
        return exprNode;
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode exprNode = this.PrecExpr(2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                ExprNode exprNode2 = this.PrecExpr1();
                this.jj_consume_token(18);
                ExprNode exprNode3 = this.PrecExpr1();
                OperatorNodes.ConditionalOpNode conditionalOpNode = new OperatorNodes.ConditionalOpNode();
                conditionalOpNode.addChild(exprNode);
                conditionalOpNode.addChild(exprNode2);
                conditionalOpNode.addChild(exprNode3);
                exprNode = conditionalOpNode;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        return exprNode;
    }

    private final ExprNode PrecExpr(int n) throws ParseException {
        ExprNode exprNode = this.Primary();
        while (this.jj_2_1(Integer.MAX_VALUE) && Operator.of(this.getToken((int)1).image, 2).getPrecedence() >= n) {
            String string = this.BinaryOp();
            ExprNode exprNode2 = this.PrecExpr(Operator.of(string, 2).getPrecedence() + 1);
            ExprNode.OperatorNode operatorNode = ExpressionParser.createOperatorNode(string, 2);
            operatorNode.addChild(exprNode);
            operatorNode.addChild(exprNode2);
            exprNode = operatorNode;
        }
        return exprNode;
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode exprNode;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                exprNode = this.Expr();
                this.jj_consume_token(20);
                break;
            }
            case 8: 
            case 9: {
                String string = this.UnaryOp();
                ExprNode exprNode2 = this.PrecExpr(Operator.of(string, 1).getPrecedence());
                ExprNode.OperatorNode operatorNode = ExpressionParser.createOperatorNode(string, 1);
                operatorNode.addChild(exprNode2);
                exprNode = operatorNode;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    exprNode = this.FunctionCall();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 23: {
                        exprNode = this.DataRef();
                        break block0;
                    }
                    case 11: {
                        exprNode = this.Global();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                if (this.jj_2_3(Integer.MAX_VALUE)) {
                    exprNode = this.ListLiteral();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        exprNode = this.MapLiteral();
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        exprNode = this.Primitive();
                        break block0;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exprNode;
    }

    private final VarNode Var() throws ParseException {
        Token token = this.jj_consume_token(12);
        String string = token.image.substring(1);
        if (string.equals("ij")) {
            throw new ParseException("Invalid var name 'ij' ('ij' is for injected data ref).");
        }
        return new VarNode(string);
    }

    private final DataRefNode DataRef() throws ParseException {
        DataRefNode dataRefNode;
        block14: {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    Token token = this.jj_consume_token(11);
                    dataRefNode = new DataRefNode(true);
                    dataRefNode.addChild(new DataRefKeyNode(token.image));
                    break;
                }
                case 12: {
                    Token token = this.jj_consume_token(12);
                    dataRefNode = new DataRefNode(false);
                    String string = token.image.substring(1);
                    if (string.equals("ij")) {
                        throw new ParseException("Invalid param name 'ij' ('ij' is for injected data ref).");
                    }
                    dataRefNode.addChild(new DataRefKeyNode(string));
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        Token token = this.jj_consume_token(13);
                        dataRefNode.addChild(new DataRefKeyNode(token.image.substring(1)));
                        continue block12;
                    }
                    case 14: {
                        Token token = this.jj_consume_token(14);
                        dataRefNode.addChild(new DataRefIndexNode(Integer.parseInt(token.image.substring(1))));
                        continue block12;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        ExprNode exprNode = this.Expr();
                        this.jj_consume_token(22);
                        dataRefNode.addChild(exprNode);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[10] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return dataRefNode;
    }

    private final GlobalNode Global() throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        Token token = this.jj_consume_token(11);
        stringBuilder.append(token.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            Token token2 = this.jj_consume_token(13);
            stringBuilder.append(token2.image);
        }
        return new GlobalNode(stringBuilder.toString());
    }

    private final FunctionNode FunctionCall() throws ParseException {
        Token token = this.jj_consume_token(11);
        this.jj_consume_token(19);
        List<ExprNode> list = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: {
                list = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(20);
        FunctionNode functionNode = new FunctionNode(token.image);
        if (list != null) {
            functionNode.addChildren((List<? extends ExprNode>)list);
        }
        return functionNode;
    }

    private final ListLiteralNode ListLiteral() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        this.jj_consume_token(21);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: {
                ExprNode exprNode = this.Expr();
                arrayList.add(exprNode);
                while (this.jj_2_4(Integer.MAX_VALUE)) {
                    this.jj_consume_token(16);
                    exprNode = this.Expr();
                    arrayList.add(exprNode);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        break block0;
                    }
                }
                this.jj_la1[13] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.jj_consume_token(22);
        return new ListLiteralNode(arrayList);
    }

    private final MapLiteralNode MapLiteral() throws ParseException {
        ArrayList arrayList = Lists.newArrayList();
        this.jj_consume_token(21);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: {
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    Token token = this.jj_consume_token(11);
                    throw new ParseException("Disallowed single-identifier key \"" + token.image + "\" in map literal" + " (please surround with single quotes for string or parentheses for global).");
                }
                ExprNode exprNode = this.Expr();
                arrayList.add(exprNode);
                this.jj_consume_token(18);
                ExprNode exprNode2 = this.Expr();
                arrayList.add(exprNode2);
                while (this.jj_2_6(Integer.MAX_VALUE)) {
                    this.jj_consume_token(16);
                    if (this.jj_2_7(Integer.MAX_VALUE)) {
                        Token token = this.jj_consume_token(11);
                        throw new ParseException("Disallowed single-identifier key \"" + token.image + "\" in map literal" + " (please surround with single quotes for string or parentheses for global).");
                    }
                    exprNode = this.Expr();
                    arrayList.add(exprNode);
                    this.jj_consume_token(18);
                    exprNode2 = this.Expr();
                    arrayList.add(exprNode2);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(22);
        return new MapLiteralNode(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    private final boolean jj_3R_8() {
        if (this.jj_3R_9()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(22)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_23() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(8)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_42();
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_50() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_24() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_scan_token(19)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(20);
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(22)) {
            this.jj_scanpos = token;
            if (this.jj_3R_8()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = token;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_29();
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_41() {
        return this.jj_scan_token(5);
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_28();
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_40() {
        return this.jj_scan_token(4);
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_34() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_18() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_39() {
        return this.jj_scan_token(3);
    }

    private final boolean jj_3R_10() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_38() {
        return this.jj_scan_token(2);
    }

    private final boolean jj_3R_26() {
        Token token;
        if (this.jj_scan_token(11)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_34());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_36() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = token;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_48());
        token = this.jj_scanpos = token;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        return this.jj_scan_token(1);
    }

    private final boolean jj_3R_16() {
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3R_15() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_29() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = token;
            if (this.jj_3R_38()) {
                this.jj_scanpos = token;
                if (this.jj_3R_39()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_40()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_41()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(18)) {
            this.jj_scanpos = token;
            if (this.jj_3R_36()) {
                return true;
            }
        }
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_13() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = token;
            if (this.jj_3R_16()) {
                this.jj_scanpos = token;
                if (this.jj_3R_17()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_18()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_19()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_20()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_21()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_22()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_9() {
        return this.jj_3R_10();
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_33() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = token;
            if (this.jj_3R_44()) {
                this.jj_scanpos = token;
                if (this.jj_3R_45()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private final boolean jj_3R_42() {
        Token token;
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_49());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_3R_11();
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_35() {
        Token token;
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_46());
        token = this.jj_scanpos = token;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = token;
            if (this.jj_3R_32()) {
                return true;
            }
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_33());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_11() {
        Token token;
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_14());
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_7() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(8)) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{62, 768, 1280, 65536, 131072, 525056, 0x801800, 2097214, 0x801000, 0x206000, 0x206000, 8192, 11017022, 65536, 11017022, 65536, 11279166};
    }

    public ExpressionParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public ExpressionParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 17; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 17; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ExpressionParser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 17; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 17; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ExpressionParser(ExpressionParserTokenManager expressionParserTokenManager) {
        int n;
        this.token_source = expressionParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 17; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ExpressionParserTokenManager expressionParserTokenManager) {
        int n;
        this.token_source = expressionParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 17; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[24];
        for (n2 = 0; n2 < 24; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 17; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 24; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ExpressionParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

