/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.ExprNode;

public class DataRefNode
extends AbstractParentExprNode {
    private final boolean isIjDataRef;
    private Boolean isLocalVarDataRef;

    public DataRefNode(boolean bl) {
        this.isIjDataRef = bl;
        this.isLocalVarDataRef = null;
    }

    protected DataRefNode(DataRefNode dataRefNode) {
        super(dataRefNode);
        this.isIjDataRef = dataRefNode.isIjDataRef;
        this.isLocalVarDataRef = dataRefNode.isLocalVarDataRef;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.DATA_REF_NODE;
    }

    public boolean isIjDataRef() {
        return this.isIjDataRef;
    }

    public void setIsLocalVarDataRef(Boolean bl) {
        this.isLocalVarDataRef = bl;
    }

    public Boolean isLocalVarDataRef() {
        return this.isLocalVarDataRef;
    }

    public String getFirstKey() {
        return ((DataRefKeyNode)this.getChild(0)).getKey();
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (ExprNode exprNode : this.getChildren()) {
            if (bl) {
                stringBuilder.append(this.isIjDataRef ? "$ij." : "$").append(exprNode.toSourceString());
                bl = false;
                continue;
            }
            if (exprNode instanceof DataRefKeyNode || exprNode instanceof DataRefIndexNode) {
                stringBuilder.append('.').append(exprNode.toSourceString());
                continue;
            }
            stringBuilder.append('[').append(exprNode.toSourceString()).append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public DataRefNode clone() {
        return new DataRefNode(this);
    }
}

