/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;

public class FunctionNode
extends AbstractParentExprNode {
    private final String functionName;

    public FunctionNode(String string) {
        this.functionName = string;
    }

    protected FunctionNode(FunctionNode functionNode) {
        super(functionNode);
        this.functionName = functionNode.functionName;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FUNCTION_NODE;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String toSourceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.functionName).append('(');
        boolean bl = true;
        for (ExprNode exprNode : this.getChildren()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(exprNode.toSourceString());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public FunctionNode clone() {
        return new FunctionNode(this);
    }
}

