/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.ExprNode;

public class StringNode
extends AbstractPrimitiveNode {
    private final String value;

    public StringNode(String string) {
        this.value = string;
    }

    protected StringNode(StringNode stringNode) {
        super(stringNode);
        this.value = stringNode.value;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.STRING_NODE;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toSourceString() {
        return this.toSourceString(false);
    }

    public String toSourceString(boolean bl) {
        return BaseUtils.escapeToSoyString(this.value, bl);
    }

    @Override
    public StringNode clone() {
        return new StringNode(this);
    }
}

