/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.base;

import com.google.template.soy.internal.base.CharEscaper;
import java.util.HashMap;
import java.util.Map;

public class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    public CharEscaperBuilder addEscape(char c, String string) {
        this.map.put(Character.valueOf(c), string);
        if (c > this.max) {
            this.max = c;
        }
        return this;
    }

    public CharEscaperBuilder addEscapes(char[] cArray, String string) {
        for (char c : cArray) {
            this.addEscape(c, string);
        }
        return this;
    }

    public char[][] toArray() {
        char[][] cArrayArray = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            cArrayArray[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return cArrayArray;
    }

    public CharEscaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[][] replacements;
        private final int replaceLength;

        public CharArrayDecorator(char[][] cArray) {
            this.replacements = cArray;
            this.replaceLength = cArray.length;
        }

        @Override
        public String escape(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= this.replacements.length || this.replacements[c] == null) continue;
                return this.escapeSlow(string, i);
            }
            return string;
        }

        @Override
        protected char[] escape(char c) {
            return c < this.replaceLength ? this.replacements[c] : null;
        }
    }
}

