/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.internal.i18n.BidiUtils;
import java.util.Locale;

public class BidiFormatter {
    private BidiUtils.Dir contextDir;
    private boolean alwaysSpan;

    public static BidiFormatter getInstance(BidiUtils.Dir dir, boolean bl) {
        return new BidiFormatter(dir, bl);
    }

    public static BidiFormatter getInstance(BidiUtils.Dir dir) {
        return BidiFormatter.getInstance(dir, false);
    }

    public static BidiFormatter getInstance(boolean bl, boolean bl2) {
        return new BidiFormatter(bl ? BidiUtils.Dir.RTL : BidiUtils.Dir.LTR, bl2);
    }

    public static BidiFormatter getInstance(boolean bl) {
        return BidiFormatter.getInstance(bl, false);
    }

    public static BidiFormatter getInstance(Locale locale, boolean bl) {
        return BidiFormatter.getInstance(BidiUtils.languageDir(locale.toString()), bl);
    }

    public static BidiFormatter getInstance(Locale locale) {
        return BidiFormatter.getInstance(locale, false);
    }

    private BidiFormatter(BidiUtils.Dir dir, boolean bl) {
        this.contextDir = dir;
        this.alwaysSpan = bl;
    }

    public BidiUtils.Dir getContextDir() {
        return this.contextDir;
    }

    public boolean isRtlContext() {
        return this.contextDir == BidiUtils.Dir.RTL;
    }

    public boolean getAlwaysSpan() {
        return this.alwaysSpan;
    }

    public String dirAttrValue(String string, boolean bl) {
        return this.knownDirAttrValue(BidiFormatter.estimateDirection(string, bl));
    }

    public String dirAttrValue(String string) {
        return this.dirAttrValue(string, false);
    }

    public String knownDirAttrValue(BidiUtils.Dir dir) {
        if (dir == BidiUtils.Dir.UNKNOWN) {
            dir = this.contextDir;
        }
        return dir == BidiUtils.Dir.RTL ? "rtl" : "ltr";
    }

    public String dirAttr(String string, boolean bl) {
        return this.knownDirAttr(BidiFormatter.estimateDirection(string, bl));
    }

    public String dirAttr(String string) {
        return this.dirAttr(string, false);
    }

    public String knownDirAttr(BidiUtils.Dir dir) {
        if (dir != this.contextDir) {
            return dir == BidiUtils.Dir.LTR ? "dir=ltr" : (dir == BidiUtils.Dir.RTL ? "dir=rtl" : "");
        }
        return "";
    }

    public String spanWrap(String string, boolean bl, boolean bl2) {
        BidiUtils.Dir dir = BidiFormatter.estimateDirection(string, bl);
        return this.spanWrapWithKnownDir(dir, string, bl, bl2);
    }

    public String spanWrap(String string, boolean bl) {
        return this.spanWrap(string, bl, true);
    }

    public String spanWrap(String string) {
        return this.spanWrap(string, false, true);
    }

    public String spanWrapWithKnownDir(BidiUtils.Dir dir, String string, boolean bl, boolean bl2) {
        boolean bl3 = dir != BidiUtils.Dir.UNKNOWN && dir != this.contextDir;
        String string2 = string;
        if (!bl) {
            string = CharEscapers.asciiHtmlEscaper().escape(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.alwaysSpan || bl3) {
            stringBuilder.append("<span");
            if (bl3) {
                stringBuilder.append(" ");
                stringBuilder.append(dir == BidiUtils.Dir.RTL ? "dir=rtl" : "dir=ltr");
            }
            stringBuilder.append(">" + string + "</span>");
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(this.dirResetIfNeeded(string2, dir, bl, bl2));
        return stringBuilder.toString();
    }

    public String spanWrapWithKnownDir(BidiUtils.Dir dir, String string, boolean bl) {
        return this.spanWrapWithKnownDir(dir, string, bl, true);
    }

    public String spanWrapWithKnownDir(BidiUtils.Dir dir, String string) {
        return this.spanWrapWithKnownDir(dir, string, false, true);
    }

    public String unicodeWrap(String string, boolean bl, boolean bl2) {
        BidiUtils.Dir dir = BidiFormatter.estimateDirection(string, bl);
        return this.unicodeWrapWithKnownDir(dir, string, bl, bl2);
    }

    public String unicodeWrap(String string, boolean bl) {
        return this.unicodeWrap(string, bl, true);
    }

    public String unicodeWrap(String string) {
        return this.unicodeWrap(string, false, true);
    }

    public String unicodeWrapWithKnownDir(BidiUtils.Dir dir, String string, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dir != BidiUtils.Dir.UNKNOWN && dir != this.contextDir) {
            stringBuilder.append(dir == BidiUtils.Dir.RTL ? (char)'\u202b' : '\u202a');
            stringBuilder.append(string);
            stringBuilder.append('\u202c');
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(this.dirResetIfNeeded(string, dir, bl, bl2));
        return stringBuilder.toString();
    }

    public String unicodeWrapWithKnownDir(BidiUtils.Dir dir, String string, boolean bl) {
        return this.unicodeWrapWithKnownDir(dir, string, bl, true);
    }

    public String unicodeWrapWithKnownDir(BidiUtils.Dir dir, String string) {
        return this.unicodeWrapWithKnownDir(dir, string, false, true);
    }

    public String markAfter(String string, boolean bl) {
        return this.dirResetIfNeeded(string, BidiFormatter.estimateDirection(string, bl), bl, true);
    }

    public String markAfter(String string) {
        return this.markAfter(string, false);
    }

    public String mark() {
        return this.contextDir == BidiUtils.Dir.LTR ? BidiUtils.Format.LRM_STRING : (this.contextDir == BidiUtils.Dir.RTL ? BidiUtils.Format.RLM_STRING : "");
    }

    public String startEdge() {
        return this.contextDir == BidiUtils.Dir.RTL ? "right" : "left";
    }

    public String endEdge() {
        return this.contextDir == BidiUtils.Dir.RTL ? "left" : "right";
    }

    public static BidiUtils.Dir estimateDirection(String string, boolean bl) {
        return BidiUtils.estimateDirection(string, bl);
    }

    public static BidiUtils.Dir estimateDirection(String string) {
        return BidiUtils.estimateDirection(string);
    }

    private String dirResetIfNeeded(String string, BidiUtils.Dir dir, boolean bl, boolean bl2) {
        if (bl2 && (this.contextDir == BidiUtils.Dir.LTR && (dir == BidiUtils.Dir.RTL || BidiUtils.endsWithRtl(string, bl)) || this.contextDir == BidiUtils.Dir.RTL && (dir == BidiUtils.Dir.LTR || BidiUtils.endsWithLtr(string, bl)))) {
            return this.contextDir == BidiUtils.Dir.LTR ? BidiUtils.Format.LRM_STRING : BidiUtils.Format.RLM_STRING;
        }
        return "";
    }
}

