/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.shared.SoyCssRenamingMap;

public class SoyJavaSrcOptions {
    private static final SoyCssRenamingMap NO_COMPILE_TIME_CSS_RENAMING = new SoyCssRenamingMap(){

        @Override
        public String get(String string) {
            return null;
        }
    };
    private CodeStyle codeStyle;
    private int bidiGlobalDir;
    private SoyCssRenamingMap cssRenamingHints;

    public SoyJavaSrcOptions() {
        this.codeStyle = CodeStyle.STRINGBUILDER;
        this.bidiGlobalDir = 0;
        this.cssRenamingHints = NO_COMPILE_TIME_CSS_RENAMING;
    }

    public SoyJavaSrcOptions(SoyJavaSrcOptions soyJavaSrcOptions) {
        this.codeStyle = soyJavaSrcOptions.codeStyle;
        this.bidiGlobalDir = soyJavaSrcOptions.bidiGlobalDir;
        this.cssRenamingHints = soyJavaSrcOptions.cssRenamingHints;
    }

    public void setCodeStyle(CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    public CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public void setBidiGlobalDir(int n) {
        Preconditions.checkArgument((n >= -1 && n <= 1 ? 1 : 0) != 0, (Object)"bidiGlobalDir must be 1 for LTR, or -1 for RTL (or 0 to leave unspecified).");
        this.bidiGlobalDir = n;
    }

    public int getBidiGlobalDir() {
        return this.bidiGlobalDir;
    }

    public void setCssRenamingHints(SoyCssRenamingMap soyCssRenamingMap) {
        this.cssRenamingHints = soyCssRenamingMap;
    }

    public SoyCssRenamingMap getCssRenamingHints() {
        return this.cssRenamingHints;
    }

    public static enum CodeStyle {
        STRINGBUILDER,
        CONCAT;

    }
}

