/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.codedeps;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.shared.restricted.Sanitizers;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyUtils {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n)");

    public static SoyData $$getData(CollectionData collectionData, String string) {
        SoyData soyData = collectionData.get(string);
        return soyData != null ? soyData : NullData.INSTANCE;
    }

    public static SoyData $$getDataSingle(CollectionData collectionData, String string) {
        SoyData soyData = collectionData.getSingle(string);
        return soyData != null ? soyData : NullData.INSTANCE;
    }

    public static SoyMapData $$augmentData(SoyMapData soyMapData, SoyMapData soyMapData2) {
        AugmentedSoyMapData augmentedSoyMapData = new AugmentedSoyMapData(soyMapData);
        for (Map.Entry<String, SoyData> entry : soyMapData2.asMap().entrySet()) {
            augmentedSoyMapData.putSingle(entry.getKey(), entry.getValue());
        }
        return augmentedSoyMapData;
    }

    public static String $$escapeHtml(SoyData soyData) {
        return Sanitizers.escapeHtml(soyData);
    }

    public static String $$escapeHtmlRcdata(SoyData soyData) {
        return Sanitizers.escapeHtmlRcdata(soyData);
    }

    public static String $$normalizeHtml(SoyData soyData) {
        return Sanitizers.normalizeHtml(soyData);
    }

    public static String $$normalizeHtmlNospace(SoyData soyData) {
        return Sanitizers.normalizeHtmlNospace(soyData);
    }

    public static String $$escapeHtmlAttribute(SoyData soyData) {
        return Sanitizers.escapeHtmlAttribute(soyData);
    }

    public static String $$escapeHtmlAttributeNospace(SoyData soyData) {
        return Sanitizers.escapeHtmlAttributeNospace(soyData);
    }

    public static String $$escapeJsString(SoyData soyData) {
        return Sanitizers.escapeJsString(soyData);
    }

    public static String $$escapeJsValue(SoyData soyData) {
        return Sanitizers.escapeJsValue(soyData);
    }

    public static String $$escapeJsRegex(SoyData soyData) {
        return Sanitizers.escapeJsRegex(soyData);
    }

    public static String $$escapeCssString(SoyData soyData) {
        return Sanitizers.escapeCssString(soyData);
    }

    public static String $$filterCssValue(SoyData soyData) {
        return Sanitizers.filterCssValue(soyData);
    }

    public static String $$escapeUri(SoyData soyData) {
        return Sanitizers.escapeUri(soyData);
    }

    public static String $$normalizeUri(SoyData soyData) {
        return Sanitizers.normalizeUri(soyData);
    }

    public static String $$filterNormalizeUri(SoyData soyData) {
        return Sanitizers.filterNormalizeUri(soyData);
    }

    public static String $$filterHtmlAttribute(SoyData soyData) {
        return Sanitizers.filterHtmlAttribute(soyData);
    }

    public static String $$filterHtmlElementName(SoyData soyData) {
        return Sanitizers.filterHtmlElementName(soyData);
    }

    public static String $$changeNewlineToBr(String string) {
        return NEWLINE_PATTERN.matcher(string).replaceAll("<br>");
    }

    public static String $$insertWordBreaks(String string, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        for (int i = 0; i < string.length(); i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n3 >= n && n2 != 32) {
                stringBuilder.append("<wbr>");
                n3 = 0;
            }
            if (bl) {
                if (n2 == 62) {
                    bl = false;
                }
            } else if (bl2) {
                switch (n2) {
                    case 59: {
                        bl2 = false;
                        ++n3;
                        break;
                    }
                    case 60: {
                        bl2 = false;
                        bl = true;
                        break;
                    }
                    case 32: {
                        bl2 = false;
                        n3 = 0;
                    }
                }
            } else {
                switch (n2) {
                    case 60: {
                        bl = true;
                        break;
                    }
                    case 38: {
                        bl2 = true;
                        break;
                    }
                    case 32: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
            }
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public static String $$truncate(String string, int n, boolean bl) {
        if (string.length() <= n) {
            return string;
        }
        if (bl) {
            if (n > 3) {
                n -= 3;
            } else {
                bl = false;
            }
        }
        if (Character.isHighSurrogate(string.charAt(n - 1)) && Character.isLowSurrogate(string.charAt(n))) {
            --n;
        }
        string = string.substring(0, n);
        if (bl) {
            string = string + "...";
        }
        return string;
    }

    public static NumberData $$negative(NumberData numberData) {
        if (numberData instanceof IntegerData) {
            return IntegerData.forValue(-numberData.integerValue());
        }
        return FloatData.forValue(-numberData.floatValue());
    }

    public static NumberData $$times(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return IntegerData.forValue(numberData.integerValue() * numberData2.integerValue());
        }
        return FloatData.forValue(numberData.numberValue() * numberData2.numberValue());
    }

    public static SoyData $$plus(SoyData soyData, SoyData soyData2) {
        if (soyData instanceof NumberData && soyData2 instanceof NumberData) {
            if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
                return IntegerData.forValue(soyData.integerValue() + soyData2.integerValue());
            }
            return FloatData.forValue(soyData.numberValue() + soyData2.numberValue());
        }
        return StringData.forValue(soyData.toString() + soyData2.toString());
    }

    public static NumberData $$minus(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return IntegerData.forValue(numberData.integerValue() - numberData2.integerValue());
        }
        return FloatData.forValue(numberData.numberValue() - numberData2.numberValue());
    }

    public static BooleanData $$lessThan(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return BooleanData.forValue(numberData.integerValue() < numberData2.integerValue());
        }
        return BooleanData.forValue(numberData.numberValue() < numberData2.numberValue());
    }

    public static BooleanData $$greaterThan(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return BooleanData.forValue(numberData.integerValue() > numberData2.integerValue());
        }
        return BooleanData.forValue(numberData.numberValue() > numberData2.numberValue());
    }

    public static BooleanData $$lessThanOrEqual(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return BooleanData.forValue(numberData.integerValue() <= numberData2.integerValue());
        }
        return BooleanData.forValue(numberData.numberValue() <= numberData2.numberValue());
    }

    public static BooleanData $$greaterThanOrEqual(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return BooleanData.forValue(numberData.integerValue() >= numberData2.integerValue());
        }
        return BooleanData.forValue(numberData.numberValue() >= numberData2.numberValue());
    }

    public static NumberData $$round(NumberData numberData, @Nullable IntegerData integerData) {
        int n;
        int n2 = n = integerData != null ? integerData.integerValue() : 0;
        if (n == 0) {
            if (numberData instanceof IntegerData) {
                return numberData;
            }
            return IntegerData.forValue((int)Math.round(numberData.numberValue()));
        }
        if (n > 0) {
            double d = numberData.numberValue();
            double d2 = Math.pow(10.0, n);
            return FloatData.forValue((double)Math.round(d * d2) / d2);
        }
        double d = numberData.numberValue();
        double d3 = Math.pow(10.0, -n);
        return IntegerData.forValue((int)((double)Math.round(d / d3) * d3));
    }

    public static NumberData $$min(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return IntegerData.forValue(Math.min(numberData.integerValue(), numberData2.integerValue()));
        }
        return FloatData.forValue(Math.min(numberData.numberValue(), numberData2.numberValue()));
    }

    public static NumberData $$max(NumberData numberData, NumberData numberData2) {
        if (numberData instanceof IntegerData && numberData2 instanceof IntegerData) {
            return IntegerData.forValue(Math.max(numberData.integerValue(), numberData2.integerValue()));
        }
        return FloatData.forValue(Math.max(numberData.numberValue(), numberData2.numberValue()));
    }
}

