/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class ClasspathUtils {
    private static final ClassLoader CLASS_LOADER = ClasspathUtils.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : ClasspathUtils.class.getClassLoader();
    private static SoftReference<Map<String, PackageContent>> packagePathToContentMapRef;

    ClasspathUtils() {
    }

    static Iterable<String> getClassResourcePaths(String string, boolean bl) throws IOException {
        URL uRL;
        ImmutableList.Builder builder = ImmutableList.builder();
        String string2 = string.replace('.', '/');
        PackageContent packageContent = ClasspathUtils.getPackagePathToContentMap().get(string2);
        if (packageContent != null) {
            packageContent.enumerateResources((ImmutableList.Builder<String>)builder, bl);
        }
        if ((uRL = CLASS_LOADER.getResource(string2)) != null) {
            String string3 = uRL.getProtocol();
            if ("file".equals(string3)) {
                try {
                    ClasspathUtils.searchFileTree(string, new File(uRL.toURI()), bl, (ImmutableList.Builder<? super String>)builder);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Throwables.propagate((Throwable)uRISyntaxException);
                }
            } else if ("jar".equals(string3)) {
                ClasspathUtils.searchZipFile(string, bl, uRL, (ImmutableList.Builder<? super String>)builder);
            }
        }
        return builder.build();
    }

    private static void searchFileTree(String string, File file, boolean bl, ImmutableList.Builder<? super String> builder) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                String string2;
                if (file2.isFile()) {
                    if (!file2.getName().endsWith(".class")) continue;
                    string2 = string.equals("") ? "" : string.replace('.', '/') + "/";
                    builder.add((Object)(string2 + file2.getName()));
                    continue;
                }
                if (!bl || !file2.isDirectory() || ".".equals(file2.getName()) || "..".equals(file2.getName())) continue;
                string2 = file2.getName();
                if (!"".equals(string)) {
                    string2 = string + "." + string2;
                }
                ClasspathUtils.searchFileTree(string2, file2, bl, builder);
            }
        }
    }

    private static void searchZipFile(String string, boolean bl, URL uRL, ImmutableList.Builder<? super String> builder) throws IOException {
        String string2 = uRL.toString();
        int n = string2.lastIndexOf(33);
        URL uRL2 = new URL(string2.substring(4, n));
        String string3 = string2.substring(n + 1);
        ClasspathUtils.searchZipAtFileForPath(string3, bl, uRL2, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchZipAtFileForPath(String string, boolean bl, URL uRL, ImmutableList.Builder<? super String> builder) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            String string2 = string;
            if (string.startsWith("/")) {
                string2 = string2.substring(1);
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName();
                if (zipEntry.isDirectory() || !string3.endsWith(".class") || !string3.startsWith(string2) || string3.lastIndexOf(47) != string2.length() && (!bl || string2.length() != 0 && string3.charAt(string2.length()) != '/')) continue;
                builder.add((Object)string3);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static Map<String, PackageContent> getPackagePathToContentMap() {
        Map<String, PackageContent> map = null;
        if (packagePathToContentMapRef != null) {
            map = packagePathToContentMapRef.get();
        }
        if (map == null) {
            map = ClasspathUtils.buildPackagePathToContentMapFromURLClassLoaders(CLASS_LOADER);
            packagePathToContentMapRef = new SoftReference<Map<String, PackageContent>>(map);
        }
        return map;
    }

    private static Map<String, PackageContent> buildPackagePathToContentMapFromURLClassLoaders(ClassLoader classLoader) {
        Object object;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (object = classLoader; object != null; object = ((ClassLoader)object).getParent()) {
            if (!(object instanceof URLClassLoader)) continue;
            for (URL object2 : ((URLClassLoader)object).getURLs()) {
                String string = object2.getProtocol();
                if (!"file".equals(string)) continue;
                try {
                    File file = new File(object2.toURI());
                    if (!file.exists()) continue;
                    try {
                        if (file.isDirectory()) {
                            ClasspathUtils.searchFileTree("", file, true, (ImmutableList.Builder<? super String>)builder);
                            continue;
                        }
                        if (!file.isFile()) continue;
                        ClasspathUtils.searchZipAtFileForPath("", true, object2, (ImmutableList.Builder<? super String>)builder);
                    }
                    catch (IOException iOException) {}
                }
                catch (URISyntaxException uRISyntaxException) {
                    Throwables.propagate((Throwable)uRISyntaxException);
                }
            }
            break;
        }
        object = new PackageTree();
        for (String string : builder.build()) {
            int n = string.lastIndexOf(47);
            String string2 = n >= 0 ? string.substring(0, n) : "";
            ((PackageTree)object).getPackageContent((String)string2).resources.add(string);
        }
        return ImmutableMap.copyOf(((PackageTree)object).packagePathToContentMap);
    }

    private static final class PackageContent {
        final List<PackageContent> subPackages = Lists.newArrayList();
        final List<String> resources = Lists.newArrayList();

        private PackageContent() {
        }

        void enumerateResources(ImmutableList.Builder<String> builder, boolean bl) {
            builder.addAll(this.resources);
            if (bl) {
                for (PackageContent packageContent : this.subPackages) {
                    packageContent.enumerateResources(builder, true);
                }
            }
        }
    }

    private static final class PackageTree {
        final Map<String, PackageContent> packagePathToContentMap = Maps.newHashMap();

        private PackageTree() {
        }

        PackageContent getPackageContent(String string) {
            PackageContent packageContent = this.packagePathToContentMap.get(string);
            if (packageContent == null) {
                packageContent = new PackageContent();
                this.packagePathToContentMap.put(string, packageContent);
                if (!"".equals(string)) {
                    int n = string.lastIndexOf(47);
                    String string2 = n < 0 ? "" : string.substring(0, n);
                    this.getPackageContent((String)string2).subPackages.add(packageContent);
                }
            }
            return packageContent;
        }
    }
}

