/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.javasrc.SoyTemplateRuntime;
import com.google.template.soy.javasrc.dyncompile.AbstractSoyTemplateRuntime;
import com.google.template.soy.javasrc.dyncompile.DynamicCompilerJavaFileManager;
import com.google.template.soy.javasrc.dyncompile.ReadableInMemoryJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.SoyTemplateClassLoader;
import com.google.template.soy.javasrc.dyncompile.WritableInMemoryJavaFileObject;
import com.google.template.soy.shared.SoyCssRenamingMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public final class SoyToJavaDynamicCompiler {
    static final String PACKAGE_FOR_COMPILED_SOY = "com.google.template.soy.javasrc.dyncompiled";
    private static final Logger LOGGER = Logger.getLogger(SoyToJavaDynamicCompiler.class.getName());

    public static ImmutableMap<String, SoyTemplateRuntime> compile(String string, String string2) {
        if (!BaseUtils.isDottedIdentifier(string)) {
            throw new IllegalArgumentException("Bundle name should be a dotted identifier, not " + string);
        }
        String string3 = Joiner.on((char)'\n').join((Object)"package com.google.template.soy.javasrc.dyncompiled;", (Object)("public final class " + string + " {"), new Object[]{"  private final " + SoyMapData.class.getName() + " $$ijData;", "  private final " + SoyCssRenamingMap.class.getName() + " $$cssRenamingMap;", "  public " + string + "(", "      " + SoyMapData.class.getName() + " ijData,", "      " + SoyCssRenamingMap.class.getName() + " cssRenamingMap) {", "    this.$$ijData = ijData;", "    this.$$cssRenamingMap = cssRenamingMap;", "  }", "  private String $$renameCss(String selectorText) {", "    return $$cssRenamingMap.get(selectorText);", "  }", "  private " + SoyData.class.getName() + " $$getIjData(String key) {", "    return $$ijData.get(key);", "  }", string2, "}"});
        DiagnosticListener<JavaFileObject> diagnosticListener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                StringBuilder stringBuilder = new StringBuilder();
                JavaFileObject javaFileObject = diagnostic.getSource();
                if (javaFileObject != null) {
                    stringBuilder.append(javaFileObject.getName()).append(':').append(diagnostic.getLineNumber()).append('+').append(diagnostic.getColumnNumber()).append(": ");
                }
                stringBuilder.append(diagnostic.getMessage(Locale.getDefault()));
                switch (diagnostic.getKind()) {
                    case ERROR: 
                    case OTHER: {
                        LOGGER.severe(stringBuilder.toString());
                        break;
                    }
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        LOGGER.warning(stringBuilder.toString());
                        break;
                    }
                }
            }
        };
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DynamicCompilerJavaFileManager dynamicCompilerJavaFileManager = new DynamicCompilerJavaFileManager(javaCompiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnosticListener, Locale.getDefault(), Charsets.UTF_8));
        String string4 = "com.google.template.soy.javasrc.dyncompiled." + string;
        ReadableInMemoryJavaFileObject readableInMemoryJavaFileObject = new ReadableInMemoryJavaFileObject("/src/" + string4.replace('.', '/') + ".java", string3);
        dynamicCompilerJavaFileManager.addInput(readableInMemoryJavaFileObject);
        boolean bl = javaCompiler.getTask(null, dynamicCompilerJavaFileManager, (DiagnosticListener<? super JavaFileObject>)diagnosticListener, (Iterable<String>)ImmutableList.of(), (Iterable<String>)ImmutableList.of(), (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)readableInMemoryJavaFileObject)).call();
        if (bl) {
            SoyTemplateClassLoader soyTemplateClassLoader = new SoyTemplateClassLoader();
            for (WritableInMemoryJavaFileObject object : dynamicCompilerJavaFileManager.getOutputFiles()) {
                soyTemplateClassLoader.defineClassCompiledFromSoy(object.getByteContent());
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            try {
                Constructor<?> constructor;
                Class<?> classNotFoundException = soyTemplateClassLoader.loadClass(string4);
                try {
                    constructor = classNotFoundException.getDeclaredConstructor(SoyMapData.class, SoyCssRenamingMap.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException("Could not find ctor for generated java class " + classNotFoundException);
                }
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    throw new AssertionError((Object)constructor.toString());
                }
                for (final Method method : classNotFoundException.getDeclaredMethods()) {
                    Class<?>[] classArray;
                    int n = method.getModifiers();
                    if (!Modifier.isPublic(n) || (classArray = method.getParameterTypes()).length != 2 || !classArray[0].isAssignableFrom(SoyMapData.class) || !classArray[1].isAssignableFrom(StringBuilder.class)) continue;
                    for (Class<?> clazz : method.getExceptionTypes()) {
                        if (!Error.class.isAssignableFrom(clazz) && RuntimeException.class.isAssignableFrom(clazz)) continue;
                    }
                    String string5 = method.getName();
                    final String string6 = string5.replace('$', '.');
                    builder.put((Object)string6, (Object)new AbstractSoyTemplateRuntime(){

                        @Override
                        protected void renderMain(SoyMapData soyMapData, SoyMapData soyMapData2, SoyCssRenamingMap soyCssRenamingMap, StringBuilder stringBuilder) {
                            try {
                                method.invoke(constructor.newInstance(soyMapData2, soyCssRenamingMap), soyMapData, stringBuilder);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Throwables.propagate((Throwable)invocationTargetException.getTargetException());
                            }
                            catch (InstantiationException instantiationException) {
                                Throwables.propagate((Throwable)instantiationException);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                Throwables.propagate((Throwable)illegalAccessException);
                            }
                        }

                        public String toString() {
                            return "[SoyTemplateRuntime " + string6 + "]";
                        }
                    });
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Throwables.propagate((Throwable)classNotFoundException);
            }
            return builder.build();
        }
        System.err.println("Java code\n" + string3 + "\n");
        throw new RuntimeException();
    }

    private SoyToJavaDynamicCompiler() {
    }
}

