/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.GenJavaCodeVisitor;
import com.google.template.soy.javasrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileSetNode;
import javax.annotation.Nullable;

public class JavaSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJavaCodeVisitor> genJavaCodeVisitorProvider;

    @Inject
    public JavaSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope guiceSimpleScope, SimplifyVisitor simplifyVisitor, Provider<OptimizeBidiCodeGenVisitor> provider, Provider<GenJavaCodeVisitor> provider2) {
        this.apiCallScope = guiceSimpleScope;
        this.simplifyVisitor = simplifyVisitor;
        this.optimizeBidiCodeGenVisitorProvider = provider;
        this.genJavaCodeVisitorProvider = provider2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String genJavaSrc(SoyFileSetNode soyFileSetNode, SoyJavaSrcOptions soyJavaSrcOptions, @Nullable SoyMsgBundle soyMsgBundle) throws SoySyntaxException {
        try {
            new InsertMsgsVisitor(soyMsgBundle, false).exec(soyFileSetNode);
        }
        catch (InsertMsgsVisitor.EncounteredPluralSelectMsgException encounteredPluralSelectMsgException) {
            throw new SoySyntaxException("JavaSrc backend doesn't support plural/select messages.");
        }
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyJavaSrcOptions.class, soyJavaSrcOptions);
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDir(soyJavaSrcOptions.getBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, bidiGlobalDir);
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyFileSetNode);
            this.simplifyVisitor.exec(soyFileSetNode);
            String string = ((GenJavaCodeVisitor)this.genJavaCodeVisitorProvider.get()).exec(soyFileSetNode);
            return string;
        }
        finally {
            this.apiCallScope.exit();
        }
    }
}

