/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.coredirectives.CoreDirectiveUtils;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.sharedpasses.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;

class OptimizeBidiCodeGenVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final String BIDI_MARK_FN_NAME = "bidiMark";
    private static final String BIDI_START_EDGE_FN_NAME = "bidiStartEdge";
    private static final String BIDI_END_EDGE_FN_NAME = "bidiEndEdge";
    private final Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap;
    private BidiGlobalDir bidiGlobalDir;
    private IdGenerator nodeIdGen;
    boolean madeReplacement;

    @Inject
    public OptimizeBidiCodeGenVisitor(Map<String, SoyJavaSrcFunction> map, BidiGlobalDir bidiGlobalDir) {
        this.soyJavaSrcFunctionsMap = map;
        this.bidiGlobalDir = bidiGlobalDir;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        if (!(this.soyJavaSrcFunctionsMap.containsKey(BIDI_MARK_FN_NAME) && this.soyJavaSrcFunctionsMap.containsKey(BIDI_START_EDGE_FN_NAME) && this.soyJavaSrcFunctionsMap.containsKey(BIDI_END_EDGE_FN_NAME))) {
            return;
        }
        this.nodeIdGen = soyFileSetNode.getNodeIdGenerator();
        this.madeReplacement = false;
        this.visitChildren(soyFileSetNode);
        if (this.madeReplacement) {
            new CombineConsecutiveRawTextNodesVisitor().exec(soyFileSetNode);
        }
    }

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        String string;
        if (printNode.getSyntaxVersion() != SoyNode.SyntaxVersion.V2) {
            return;
        }
        SoyNode.BlockNode blockNode = printNode.getParent();
        if (blockNode instanceof SoyNode.MsgBlockNode) {
            return;
        }
        Node node = printNode.getExprUnion().getExpr().getChild(0);
        if (!(node instanceof FunctionNode)) {
            return;
        }
        if (!this.bidiGlobalDir.isStaticValue()) {
            return;
        }
        String string2 = ((FunctionNode)node).getFunctionName();
        if (string2.equals(BIDI_MARK_FN_NAME)) {
            string = this.bidiGlobalDir.getStaticValue() < 0 ? "\\u200F" : "\\u200E";
        } else if (string2.equals(BIDI_START_EDGE_FN_NAME)) {
            string = this.bidiGlobalDir.getStaticValue() < 0 ? "right" : "left";
        } else if (string2.equals(BIDI_END_EDGE_FN_NAME)) {
            string = this.bidiGlobalDir.getStaticValue() < 0 ? "left" : "right";
        } else {
            return;
        }
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            if (CoreDirectiveUtils.isCoreDirective(printDirectiveNode)) continue;
            return;
        }
        blockNode.replaceChild(printNode, new RawTextNode(this.nodeIdGen.genId(), string));
        this.madeReplacement = true;
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

