/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc;

import com.google.common.base.Preconditions;

public class SoyJsSrcOptions
implements Cloneable {
    private boolean shouldAllowDeprecatedSyntax = false;
    private boolean isUsingIjData = false;
    private CodeStyle codeStyle = CodeStyle.STRINGBUILDER;
    private boolean shouldGenerateJsdoc = false;
    private boolean shouldProvideRequireSoyNamespaces = false;
    private boolean shouldProvideRequireJsFunctions = false;
    private boolean shouldDeclareTopLevelNamespaces = true;
    private boolean shouldGenerateGoogMsgDefs = false;
    private boolean googMsgsAreExternal = false;
    private int bidiGlobalDir = 0;
    private boolean useGoogIsRtlForBidiGlobalDir = false;

    public void setShouldAllowDeprecatedSyntax(boolean bl) {
        this.shouldAllowDeprecatedSyntax = bl;
    }

    public boolean shouldAllowDeprecatedSyntax() {
        return this.shouldAllowDeprecatedSyntax;
    }

    public void setIsUsingIjData(boolean bl) {
        this.isUsingIjData = bl;
    }

    public boolean isUsingIjData() {
        return this.isUsingIjData;
    }

    public void setCodeStyle(CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    public CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public void setShouldGenerateJsdoc(boolean bl) {
        this.shouldGenerateJsdoc = bl;
    }

    public boolean shouldGenerateJsdoc() {
        return this.shouldGenerateJsdoc;
    }

    public void setShouldProvideRequireSoyNamespaces(boolean bl) {
        this.shouldProvideRequireSoyNamespaces = bl;
        Preconditions.checkState((!this.shouldProvideRequireSoyNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Must not enable both shouldProvideRequireSoyNamespaces and shouldProvideRequireJsFunctions.");
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireSoyNamespaces ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireSoyNamespaces is enabled.");
    }

    public boolean shouldProvideRequireSoyNamespaces() {
        return this.shouldProvideRequireSoyNamespaces;
    }

    public void setShouldProvideRequireJsFunctions(boolean bl) {
        this.shouldProvideRequireJsFunctions = bl;
        Preconditions.checkState((!this.shouldProvideRequireSoyNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Must not enable both shouldProvideRequireSoyNamespaces and shouldProvideRequireJsFunctions.");
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireJsFunctions is enabled.");
    }

    public boolean shouldProvideRequireJsFunctions() {
        return this.shouldProvideRequireJsFunctions;
    }

    public void setShouldDeclareTopLevelNamespaces(boolean bl) {
        this.shouldDeclareTopLevelNamespaces = bl;
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireSoyNamespaces ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireSoyNamespaces is enabled.");
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireJsFunctions is enabled.");
    }

    public boolean shouldDeclareTopLevelNamespaces() {
        return this.shouldDeclareTopLevelNamespaces;
    }

    public void setShouldGenerateGoogMsgDefs(boolean bl) {
        this.shouldGenerateGoogMsgDefs = bl;
    }

    public boolean shouldGenerateGoogMsgDefs() {
        return this.shouldGenerateGoogMsgDefs;
    }

    public void setGoogMsgsAreExternal(boolean bl) {
        this.googMsgsAreExternal = bl;
    }

    public boolean googMsgsAreExternal() {
        return this.googMsgsAreExternal;
    }

    public void setBidiGlobalDir(int n) {
        Preconditions.checkArgument((n >= -1 && n <= 1 ? 1 : 0) != 0, (Object)"bidiGlobalDir must be 1 for LTR, or -1 for RTL (or 0 to leave unspecified).");
        Preconditions.checkState((!this.useGoogIsRtlForBidiGlobalDir || n == 0 ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and useGoogIsRtlForBidiGlobalDir.");
        this.bidiGlobalDir = n;
    }

    public int getBidiGlobalDir() {
        return this.bidiGlobalDir;
    }

    public void setUseGoogIsRtlForBidiGlobalDir(boolean bl) {
        Preconditions.checkState((!bl || this.shouldGenerateGoogMsgDefs ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without shouldGenerateGoogMsgDefs.");
        Preconditions.checkState((!bl || this.shouldProvideRequireSoyNamespaces || this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without either shouldProvideRequireSoyNamespaces or shouldProvideRequireJsFunctions.");
        Preconditions.checkState((!bl || this.bidiGlobalDir == 0 ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and useGoogIsRtlForBidiGlobalDir.");
        this.useGoogIsRtlForBidiGlobalDir = bl;
    }

    public boolean getUseGoogIsRtlForBidiGlobalDir() {
        return this.useGoogIsRtlForBidiGlobalDir;
    }

    public SoyJsSrcOptions clone() {
        try {
            return (SoyJsSrcOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Cloneable interface removed from SoyJsSrcOptions");
        }
    }

    public static enum CodeStyle {
        STRINGBUILDER,
        CONCAT;

    }
}

