/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.HasPluralSelectMsgVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.msgs.restricted.IcuSyntaxUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GenJsCodeVisitor
extends AbstractSoyNodeVisitor<List<String>> {
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private static final String GOOG_IS_RTL_NAMESPACE = "goog.i18n.bidi";
    private static final String GOOG_MESSAGE_FORMAT_NAMESPACE = "goog.i18n.MessageFormat";
    private final SoyJsSrcOptions jsSrcOptions;
    private final boolean isUsingIjData;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    protected JsCodeBuilder jsCodeBuilder;
    @VisibleForTesting
    protected Deque<Map<String, JsExpr>> localVarTranslations;

    @Inject
    GenJsCodeVisitor(SoyJsSrcOptions soyJsSrcOptions, @ApiCallScopeBindingAnnotations.IsUsingIjData boolean bl, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsSrcOptions = soyJsSrcOptions;
        this.isUsingIjData = bl;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    @Override
    public List<String> exec(SoyNode soyNode) {
        this.jsFilesContents = Lists.newArrayList();
        this.jsCodeBuilder = null;
        this.localVarTranslations = null;
        this.visit(soyNode);
        return this.jsFilesContents;
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode soyNode) {
        super.visit(soyNode);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> parentSoyNode) {
        if (parentSoyNode.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(parentSoyNode.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode soyNode : parentSoyNode.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode)).booleanValue()) {
                arrayList.addAll(this.genJsExprsVisitor.exec(soyNode));
                continue;
            }
            if (arrayList.size() > 0) {
                this.jsCodeBuilder.addToOutputVar(arrayList);
                arrayList.clear();
            }
            this.visit(soyNode);
        }
        if (arrayList.size() > 0) {
            this.jsCodeBuilder.addToOutputVar(arrayList);
            arrayList.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            try {
                this.visit(soyFileNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setFilePath(soyFileNode.getFilePath());
            }
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFileNode) {
        this.jsCodeBuilder = new JsCodeBuilder(this.jsSrcOptions.getCodeStyle());
        this.jsCodeBuilder.appendLine("// This file was automatically generated from ", soyFileNode.getFileName(), ".");
        this.jsCodeBuilder.appendLine("// Please don't edit this file by hand.");
        if (soyFileNode.getDelPackageName() != null) {
            this.jsCodeBuilder.appendLine(new String[0]);
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @modName {", soyFileNode.getDelPackageName(), "}");
            this.jsCodeBuilder.appendLine(" */");
        }
        this.jsCodeBuilder.appendLine(new String[0]);
        if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            this.addCodeToProvideRequireSoyNamespaces(soyFileNode);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            this.addCodeToProvideRequireJsFunctions(soyFileNode);
        } else {
            this.addCodeToDefineJsNamespaces(soyFileNode);
        }
        for (TemplateNode templateNode : soyFileNode.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(templateNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setTemplateName(templateNode.getTemplateNameForUserMsgs());
            }
        }
        this.jsFilesContents.add(this.jsCodeBuilder.getCode());
        this.jsCodeBuilder = null;
    }

    private void addCodeToDefineJsNamespaces(SoyFileNode soyFileNode) {
        TreeSet treeSet = Sets.newTreeSet();
        for (Object object : soyFileNode.getChildren()) {
            String string = ((TemplateNode)object).getTemplateName();
            Matcher matcher = DOT.matcher(string);
            while (matcher.find()) {
                treeSet.add(string.substring(0, matcher.start()));
            }
        }
        for (Object object : treeSet) {
            boolean bl;
            boolean bl2 = bl = ((String)object).indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !bl) continue;
            this.jsCodeBuilder.appendLine(new String[]{"if (typeof ", object, " == 'undefined') { ", bl ? "" : "var ", object, " = {}; }"});
        }
    }

    private void addCodeToProvideRequireSoyNamespaces(SoyFileNode soyFileNode) {
        this.jsCodeBuilder.appendLine("goog.provide('", soyFileNode.getNamespace(), "');");
        this.jsCodeBuilder.appendLine(new String[0]);
        this.jsCodeBuilder.appendLine("goog.require('soy');");
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine("goog.require('soy.StringBuilder');");
        }
        String string = null;
        for (String string2 : new FindCalleesNotInFileVisitor().exec(soyFileNode)) {
            int n = string2.lastIndexOf(46);
            if (n == -1) {
                throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("When using the option to provide/require Soy namespaces, found a called template \"" + string2 + "\" that does not reside in a namespace.", null, soyFileNode);
            }
            String string3 = string2.substring(0, n);
            if (string3.length() <= 0 || string3.equals(string)) continue;
            this.jsCodeBuilder.appendLine("goog.require('", string3, "');");
            string = string3;
        }
        if (new HasPluralSelectMsgVisitor().exec(soyFileNode).booleanValue()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_MESSAGE_FORMAT_NAMESPACE, "');");
        }
        if (this.jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_IS_RTL_NAMESPACE, "');");
        }
    }

    private void addCodeToProvideRequireJsFunctions(SoyFileNode soyFileNode) {
        TreeSet treeSet = Sets.newTreeSet();
        for (TemplateNode object : soyFileNode.getChildren()) {
            if (object instanceof TemplateBasicNode && ((TemplateBasicNode)object).isOverride()) continue;
            treeSet.add(object.getTemplateName());
        }
        for (String string : treeSet) {
            this.jsCodeBuilder.appendLine("goog.provide('", string, "');");
        }
        this.jsCodeBuilder.appendLine(new String[0]);
        this.jsCodeBuilder.appendLine("goog.require('soy');");
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.jsCodeBuilder.appendLine("goog.require('soy.StringBuilder');");
        }
        for (String string : new FindCalleesNotInFileVisitor().exec(soyFileNode)) {
            this.jsCodeBuilder.appendLine("goog.require('", string, "');");
        }
        if (new HasPluralSelectMsgVisitor().exec(soyFileNode).booleanValue()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_MESSAGE_FORMAT_NAMESPACE, "');");
        }
        if (this.jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir()) {
            this.jsCodeBuilder.appendLine("goog.require('", GOOG_IS_RTL_NAMESPACE, "');");
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        Object object;
        boolean bl = this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations = new ArrayDeque<Map<String, JsExpr>>();
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations);
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_data");
            if (bl) {
                this.jsCodeBuilder.appendLine(" * @param {soy.StringBuilder=} opt_sb");
            } else if (this.isUsingIjData) {
                this.jsCodeBuilder.appendLine(" * @param {*=} opt_ignored");
            }
            if (this.isUsingIjData) {
                this.jsCodeBuilder.appendLine(" * @param {Object.<string, *>=} opt_ijData");
            }
            this.jsCodeBuilder.appendLine(" * @return {string}");
            this.jsCodeBuilder.appendLine(" * @notypecheck");
            this.jsCodeBuilder.appendLine(" */");
        }
        this.jsCodeBuilder.appendLine(templateNode.getTemplateName(), " = function(opt_data", bl ? ", opt_sb" : (this.isUsingIjData ? ", opt_ignored" : ""), this.isUsingIjData ? ", opt_ijData" : "", ") {");
        this.jsCodeBuilder.increaseIndent();
        this.localVarTranslations.push(Maps.newHashMap());
        if (!bl && ((Boolean)this.isComputableAsJsExprsVisitor.exec(templateNode)).booleanValue()) {
            object = this.genJsExprsVisitor.exec(templateNode);
            JsExpr jsExpr = JsExprUtils.concatJsExprs(object);
            this.jsCodeBuilder.appendLine("return ", jsExpr.getText(), ";");
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            if (bl) {
                this.jsCodeBuilder.appendLine("var output = opt_sb || new soy.StringBuilder();");
                this.jsCodeBuilder.setOutputVarInited();
            }
            this.visitChildren(templateNode);
            if (bl) {
                this.jsCodeBuilder.appendLine("return opt_sb ? '' : output.toString();");
            } else {
                this.jsCodeBuilder.appendLine("return output;");
            }
            this.jsCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("};");
        if (templateNode instanceof TemplateDelegateNode) {
            object = (TemplateDelegateNode)templateNode;
            this.jsCodeBuilder.appendLine("soy.$$registerDelegateFn(soy.$$getDelegateId('", ((TemplateDelegateNode)object).getDelTemplateName(), "'), ", Integer.toString(((TemplateDelegateNode)object).getDelPriority()), ", ", ((TemplateNode)object).getTemplateName(), ");");
        }
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode googMsgNode) {
        GoogMsgCodeGenInfo googMsgCodeGenInfo = new GoogMsgCodeGenInfo();
        this.genGoogMsgCodeForChildren(googMsgNode, googMsgNode, googMsgCodeGenInfo);
        String string = BaseUtils.escapeToSoyString(googMsgCodeGenInfo.msgTextCodeSb.toString(), false);
        string = JsSrcUtils.escapeUnicodeFormatChars(string);
        this.jsCodeBuilder.indent().append("/** ");
        if (googMsgNode.getMeaning() != null) {
            this.jsCodeBuilder.append("@meaning ", googMsgNode.getMeaning(), "\n");
            this.jsCodeBuilder.indent().append(" *  ");
        }
        this.jsCodeBuilder.append("@desc ", googMsgNode.getDesc());
        if (googMsgNode.isHidden()) {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append(" *  @hidden");
        }
        this.jsCodeBuilder.append(" */\n");
        String string2 = googMsgNode.getGoogMsgVarName();
        this.jsCodeBuilder.indent().append("var ", string2, " = goog.getMsg(");
        if (googMsgCodeGenInfo.placeholderCodeBits.size() == 0) {
            this.jsCodeBuilder.append(string);
        } else {
            this.jsCodeBuilder.append("\n");
            this.jsCodeBuilder.indent().append("    ", string, ",");
            this.appendCodeBits(googMsgCodeGenInfo.placeholderCodeBits);
        }
        this.jsCodeBuilder.append(");\n");
        if (googMsgCodeGenInfo.pluralSelectVarCodeBits.size() > 0) {
            this.jsCodeBuilder.indent().append("var ", googMsgNode.getRenderedGoogMsgVarName(), " = (new goog.i18n.MessageFormat(", string2, ")).formatIgnoringPound(");
            this.appendCodeBits(googMsgCodeGenInfo.pluralSelectVarCodeBits);
            this.jsCodeBuilder.append(");\n");
        }
    }

    private void appendCodeBits(List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                this.jsCodeBuilder.append("\n");
                this.jsCodeBuilder.indent().append("    {");
                bl = false;
            } else {
                this.jsCodeBuilder.append(",\n");
                this.jsCodeBuilder.indent().append("     ");
            }
            this.jsCodeBuilder.append(string);
        }
        this.jsCodeBuilder.append("}");
    }

    private void genGoogMsgCodeForChildren(SoyNode.BlockNode blockNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        StringBuilder stringBuilder = googMsgCodeGenInfo.msgTextCodeSb;
        if (blockNode instanceof MsgPluralCaseNode) {
            stringBuilder.append(IcuSyntaxUtils.getPluralCaseOpenString(((MsgPluralCaseNode)blockNode).getCaseNumber()));
        } else if (blockNode instanceof MsgPluralDefaultNode) {
            stringBuilder.append(IcuSyntaxUtils.getPluralCaseOpenString(null));
        } else if (blockNode instanceof MsgSelectCaseNode) {
            stringBuilder.append(IcuSyntaxUtils.getSelectCaseOpenString(((MsgSelectCaseNode)blockNode).getCaseValue()));
        } else if (blockNode instanceof MsgSelectDefaultNode) {
            stringBuilder.append(IcuSyntaxUtils.getSelectCaseOpenString(null));
        }
        for (SoyNode.StandaloneNode standaloneNode : blockNode.getChildren()) {
            if (standaloneNode instanceof RawTextNode) {
                stringBuilder.append(((RawTextNode)standaloneNode).getRawText());
                continue;
            }
            if (standaloneNode instanceof MsgPlaceholderNode) {
                this.genGoogMsgCodeForMsgPlaceholderNode((MsgPlaceholderNode)standaloneNode, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (standaloneNode instanceof MsgPluralNode) {
                this.genGoogMsgCodeForPluralNode((MsgPluralNode)standaloneNode, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (standaloneNode instanceof MsgSelectNode) {
                this.genGoogMsgCodeForSelectNode((MsgSelectNode)standaloneNode, googMsgNode, googMsgCodeGenInfo);
                continue;
            }
            if (standaloneNode instanceof MsgPluralRemainderNode) {
                stringBuilder.append(IcuSyntaxUtils.getPluralRemainderString());
                continue;
            }
            String string = blockNode instanceof SoyNode.CommandNode ? "Tag " + ((SoyNode.CommandNode)((Object)blockNode)).getTagString() : "Node " + blockNode.toString();
            throw new SoySyntaxException(string + " is not allowed to be a direct child of a 'msg' tag.");
        }
        if (blockNode instanceof MsgPluralCaseNode || blockNode instanceof MsgPluralDefaultNode) {
            stringBuilder.append(IcuSyntaxUtils.getPluralCaseCloseString());
        } else if (blockNode instanceof MsgSelectCaseNode || blockNode instanceof MsgSelectDefaultNode) {
            stringBuilder.append(IcuSyntaxUtils.getSelectCaseCloseString());
        }
    }

    private void genGoogMsgCodeForPluralNode(MsgPluralNode msgPluralNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String string = googMsgNode.getPluralVarName(msgPluralNode);
        StringBuilder stringBuilder = googMsgCodeGenInfo.msgTextCodeSb;
        stringBuilder.append(IcuSyntaxUtils.getPluralOpenString(string, msgPluralNode.getOffset()));
        this.updatePluralSelectVarCodeBits(googMsgCodeGenInfo, string, this.jsExprTranslator.translateToJsExpr(msgPluralNode.getExpr(), null, this.localVarTranslations).getText());
        for (CaseOrDefaultNode caseOrDefaultNode : msgPluralNode.getChildren()) {
            this.genGoogMsgCodeForChildren(caseOrDefaultNode, googMsgNode, googMsgCodeGenInfo);
        }
        stringBuilder.append(IcuSyntaxUtils.getPluralCloseString());
    }

    private void genGoogMsgCodeForSelectNode(MsgSelectNode msgSelectNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String string = googMsgNode.getSelectVarName(msgSelectNode);
        StringBuilder stringBuilder = googMsgCodeGenInfo.msgTextCodeSb;
        stringBuilder.append(IcuSyntaxUtils.getSelectOpenString(string));
        this.updatePluralSelectVarCodeBits(googMsgCodeGenInfo, string, this.jsExprTranslator.translateToJsExpr(msgSelectNode.getExpr(), null, this.localVarTranslations).getText());
        for (CaseOrDefaultNode caseOrDefaultNode : msgSelectNode.getChildren()) {
            this.genGoogMsgCodeForChildren(caseOrDefaultNode, googMsgNode, googMsgCodeGenInfo);
        }
        stringBuilder.append(IcuSyntaxUtils.getSelectCloseString());
    }

    private void genGoogMsgCodeForMsgPlaceholderNode(MsgPlaceholderNode msgPlaceholderNode, GoogMsgNode googMsgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        String string = googMsgNode.getPlaceholderName(msgPlaceholderNode);
        String string2 = this.genGoogMsgPlaceholderName(string);
        googMsgCodeGenInfo.msgTextCodeSb.append("{$").append(string2).append("}");
        this.updatePlaceholderCodeBits(googMsgCodeGenInfo, string, string2, this.genGoogMsgPlaceholderExpr(msgPlaceholderNode).getText());
    }

    private void updatePluralSelectVarCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String string, String string2) {
        if (googMsgCodeGenInfo.seenPluralSelectVarNames.contains(string)) {
            return;
        }
        googMsgCodeGenInfo.seenPluralSelectVarNames.add(string);
        String string3 = "'" + string + "': " + string2;
        googMsgCodeGenInfo.pluralSelectVarCodeBits.add(string3);
    }

    private void updatePlaceholderCodeBits(GoogMsgCodeGenInfo googMsgCodeGenInfo, String string, String string2, String string3) {
        if (googMsgCodeGenInfo.seenPlaceholderNames.contains(string)) {
            return;
        }
        googMsgCodeGenInfo.seenPlaceholderNames.add(string);
        String string4 = "'" + string2 + "': " + string3;
        googMsgCodeGenInfo.placeholderCodeBits.add(string4);
    }

    private String genGoogMsgPlaceholderName(String string) {
        Matcher matcher = UNDERSCORE_NUMBER_SUFFIX.matcher(string);
        if (matcher.find()) {
            String string2 = string.substring(0, matcher.start());
            String string3 = matcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string2) + string3;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string);
    }

    private JsExpr genGoogMsgPlaceholderExpr(MsgPlaceholderNode msgPlaceholderNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode.StandaloneNode standaloneNode : msgPlaceholderNode.getChildren()) {
            if (standaloneNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(standaloneNode)).booleanValue()) {
                this.visit(standaloneNode);
                arrayList.add(new JsExpr("htmlTag" + standaloneNode.getId(), Integer.MAX_VALUE));
                continue;
            }
            if (standaloneNode instanceof CallNode) {
                CallNode callNode = (CallNode)standaloneNode;
                for (CallParamNode callParamNode : callNode.getChildren()) {
                    if (!(callParamNode instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(callParamNode)).booleanValue()) continue;
                    this.visit(callParamNode);
                }
                arrayList.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations));
                continue;
            }
            arrayList.addAll(this.genJsExprsVisitor.exec(standaloneNode));
        }
        return JsExprUtils.concatJsExprs(arrayList);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(msgHtmlTagNode)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("htmlTag" + msgHtmlTagNode.getId());
        this.visitChildren(msgHtmlTagNode);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(printNode));
    }

    @Override
    protected void visitLetValueNode(LetValueNode letValueNode) {
        String string = letValueNode.getUniqueVarName();
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(letValueNode.getValueExpr(), null, this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", string, " = ", jsExpr.getText(), ";");
        this.localVarTranslations.peek().put(letValueNode.getVarName(), new JsExpr(string, Integer.MAX_VALUE));
    }

    @Override
    protected void visitLetContentNode(LetContentNode letContentNode) {
        String string = letContentNode.getUniqueVarName();
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar(string);
        this.visitChildren(letContentNode);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
        this.localVarTranslations.peek().put(letContentNode.getVarName(), new JsExpr(string, Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode ifNode) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(ifNode)).booleanValue()) {
            this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(ifNode));
            return;
        }
        for (SoyNode soyNode : ifNode.getChildren()) {
            AbstractBlockCommandNode abstractBlockCommandNode;
            if (soyNode instanceof IfCondNode) {
                abstractBlockCommandNode = (IfCondNode)soyNode;
                JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(((IfCondNode)abstractBlockCommandNode).getExprUnion().getExpr(), ((IfCondNode)abstractBlockCommandNode).getExprText(), this.localVarTranslations);
                if (((IfCondNode)abstractBlockCommandNode).getCommandName().equals("if")) {
                    this.jsCodeBuilder.appendLine("if (", jsExpr.getText(), ") {");
                } else {
                    this.jsCodeBuilder.appendLine("} else if (", jsExpr.getText(), ") {");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(abstractBlockCommandNode);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (soyNode instanceof IfElseNode) {
                abstractBlockCommandNode = (IfElseNode)soyNode;
                this.jsCodeBuilder.appendLine("} else {");
                this.jsCodeBuilder.increaseIndent();
                this.visit(abstractBlockCommandNode);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitSwitchNode(SwitchNode switchNode) {
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(switchNode.getExpr(), switchNode.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("switch (", jsExpr.getText(), ") {");
        this.jsCodeBuilder.increaseIndent();
        for (SoyNode soyNode : switchNode.getChildren()) {
            CaseOrDefaultNode caseOrDefaultNode;
            if (soyNode instanceof SwitchCaseNode) {
                caseOrDefaultNode = (SwitchCaseNode)soyNode;
                for (ExprRootNode<?> exprRootNode : caseOrDefaultNode.getExprList()) {
                    JsExpr jsExpr2 = this.jsExprTranslator.translateToJsExpr(exprRootNode, null, this.localVarTranslations);
                    this.jsCodeBuilder.appendLine("case ", jsExpr2.getText(), ":");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(caseOrDefaultNode);
                this.jsCodeBuilder.appendLine("break;");
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (soyNode instanceof SwitchDefaultNode) {
                caseOrDefaultNode = (SwitchDefaultNode)soyNode;
                this.jsCodeBuilder.appendLine("default:");
                this.jsCodeBuilder.increaseIndent();
                this.visit(caseOrDefaultNode);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForeachNode(ForeachNode foreachNode) {
        boolean bl;
        String string = foreachNode.getVarName();
        String string2 = Integer.toString(foreachNode.getId());
        String string3 = string + "List" + string2;
        String string4 = string + "ListLen" + string2;
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(foreachNode.getExpr(), foreachNode.getExprText(), this.localVarTranslations);
        this.jsCodeBuilder.appendLine("var ", string3, " = ", jsExpr.getText(), ";");
        this.jsCodeBuilder.appendLine("var ", string4, " = ", string3, ".length;");
        boolean bl2 = bl = foreachNode.numChildren() == 2;
        if (bl) {
            this.jsCodeBuilder.appendLine("if (", string4, " > 0) {");
            this.jsCodeBuilder.increaseIndent();
        }
        this.visit((SoyNode)foreachNode.getChild(0));
        if (bl) {
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("} else {");
            this.jsCodeBuilder.increaseIndent();
            this.visit((SoyNode)foreachNode.getChild(1));
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode foreachNonemptyNode) {
        String string = foreachNonemptyNode.getVarName();
        String string2 = Integer.toString(foreachNonemptyNode.getForeachNodeId());
        String string3 = string + "List" + string2;
        String string4 = string + "ListLen" + string2;
        String string5 = string + "Index" + string2;
        String string6 = string + "Data" + string2;
        this.jsCodeBuilder.appendLine("for (var ", string5, " = 0; ", string5, " < ", string4, "; ", string5, "++) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("var ", string6, " = ", string3, "[", string5, "];");
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string, new JsExpr(string6, Integer.MAX_VALUE));
        hashMap.put(string + "__isFirst", new JsExpr(string5 + " == 0", Operator.EQUAL.getPrecedence()));
        hashMap.put(string + "__isLast", new JsExpr(string5 + " == " + string4 + " - 1", Operator.EQUAL.getPrecedence()));
        hashMap.put(string + "__index", new JsExpr(string5, Integer.MAX_VALUE));
        this.localVarTranslations.push(hashMap);
        this.visitChildren(foreachNonemptyNode);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForNode(ForNode forNode) {
        String string;
        String string2;
        String string3;
        String string4 = forNode.getVarName();
        String string5 = Integer.toString(forNode.getId());
        ArrayList arrayList = Lists.newArrayList(forNode.getRangeArgs());
        String string6 = arrayList.size() == 3 ? this.jsExprTranslator.translateToJsExpr((ExprNode)arrayList.remove(2), null, this.localVarTranslations).getText() : "1";
        String string7 = arrayList.size() == 2 ? this.jsExprTranslator.translateToJsExpr((ExprNode)arrayList.remove(0), null, this.localVarTranslations).getText() : "0";
        String string8 = this.jsExprTranslator.translateToJsExpr((ExprNode)arrayList.get(0), null, this.localVarTranslations).getText();
        if (INTEGER.matcher(string7).matches()) {
            string3 = string7;
        } else {
            string3 = string4 + "Init" + string5;
            this.jsCodeBuilder.appendLine("var ", string3, " = ", string7, ";");
        }
        if (INTEGER.matcher(string8).matches()) {
            string2 = string8;
        } else {
            string2 = string4 + "Limit" + string5;
            this.jsCodeBuilder.appendLine("var ", string2, " = ", string8, ";");
        }
        if (INTEGER.matcher(string6).matches()) {
            string = string6;
        } else {
            string = string4 + "Increment" + string5;
            this.jsCodeBuilder.appendLine("var ", string, " = ", string6, ";");
        }
        String string9 = string.equals("1") ? string4 + string5 + "++" : string4 + string5 + " += " + string;
        this.jsCodeBuilder.appendLine("for (var ", string4, string5, " = ", string3, "; ", string4, string5, " < ", string2, "; ", string9, ") {");
        this.jsCodeBuilder.increaseIndent();
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string4, new JsExpr(string4 + string5, Integer.MAX_VALUE));
        this.localVarTranslations.push(hashMap);
        this.visitChildren(forNode);
        this.localVarTranslations.pop();
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitCallNode(CallNode callNode) {
        Object object;
        for (Object object2 : callNode.getChildren()) {
            if (!(object2 instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(object2)).booleanValue()) continue;
            this.visit((SoyNode)object2);
        }
        if (this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            Object object2;
            object = this.genCallCodeUtils.genObjToPass(callNode, this.localVarTranslations);
            object2 = callNode instanceof CallBasicNode ? ((CallBasicNode)callNode).getCalleeName() : "soy.$$getDelegateFn(soy.$$getDelegateId('" + ((CallDelegateNode)callNode).getDelCalleeName() + "'))";
            this.jsCodeBuilder.indent().append(new String[]{object2, "(", ((JsExpr)object).getText(), ", "}).appendOutputVarName().append(this.isUsingIjData ? ", opt_ijData" : "").append(");\n");
        } else {
            object = this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations);
            this.jsCodeBuilder.addToOutputVar((List<JsExpr>)ImmutableList.of((Object)object));
        }
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode callParamContentNode) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(callParamContentNode)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.jsCodeBuilder.pushOutputVar("param" + callParamContentNode.getId());
        this.visitChildren(callParamContentNode);
        this.jsCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            if (soyNode instanceof SoyNode.BlockNode) {
                this.localVarTranslations.push(Maps.newHashMap());
                this.visitChildren((SoyNode.BlockNode)soyNode);
                this.localVarTranslations.pop();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)soyNode);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addToOutputVar(this.genJsExprsVisitor.exec(soyNode));
    }

    private class GoogMsgCodeGenInfo {
        public StringBuilder msgTextCodeSb = new StringBuilder();
        public List<String> placeholderCodeBits = Lists.newArrayList();
        public Set<String> seenPlaceholderNames = Sets.newHashSet();
        public List<String> pluralSelectVarCodeBits = Lists.newArrayList();
        public Set<String> seenPluralSelectVarNames = Sets.newHashSet();
    }
}

