/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.jssrc.GoogMsgRefNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class GenJsExprsVisitor
extends AbstractSoyNodeVisitor<List<JsExpr>> {
    Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private List<JsExpr> jsExprs;

    @AssistedInject
    GenJsExprsVisitor(Map<String, SoyJsSrcPrintDirective> map, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitorFactory genJsExprsVisitorFactory, @Assisted Deque<Map<String, JsExpr>> deque) {
        this.soyJsSrcDirectivesMap = map;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.localVarTranslations = deque;
    }

    @Override
    public List<JsExpr> exec(SoyNode soyNode) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode)));
        this.jsExprs = Lists.newArrayList();
        this.visit(soyNode);
        return this.jsExprs;
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitRawTextNode(RawTextNode rawTextNode) {
        String string = BaseUtils.escapeToSoyString(rawTextNode.getRawText(), false);
        string = JsSrcUtils.escapeUnicodeFormatChars(string);
        string = string.replace("</script>", "<\\/script>");
        this.jsExprs.add(new JsExpr(string, Integer.MAX_VALUE));
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode msgPlaceholderNode) {
        this.visitChildren(msgPlaceholderNode);
    }

    @Override
    protected void visitGoogMsgRefNode(GoogMsgRefNode googMsgRefNode) {
        this.jsExprs.add(new JsExpr(googMsgRefNode.getRenderedGoogMsgVarName(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        this.visitChildren(msgHtmlTagNode);
    }

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(printNode.getExprUnion().getExpr(), printNode.getExprText(), this.localVarTranslations);
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            SoyJsSrcPrintDirective soyJsSrcPrintDirective = this.soyJsSrcDirectivesMap.get(printDirectiveNode.getName());
            if (soyJsSrcPrintDirective == null) {
                throw new SoySyntaxException("Failed to find SoyJsSrcPrintDirective with name '" + printDirectiveNode.getName() + "'" + " (tag " + printNode.toSourceString() + ")");
            }
            List<ExprRootNode<?>> list = printDirectiveNode.getArgs();
            if (!soyJsSrcPrintDirective.getValidArgsSizes().contains(list.size())) {
                throw new SoySyntaxException("Print directive '" + printDirectiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
            }
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
            for (ExprRootNode<?> exprRootNode : list) {
                arrayList.add(this.jsExprTranslator.translateToJsExpr(exprRootNode, null, this.localVarTranslations));
            }
            jsExpr = soyJsSrcPrintDirective.applyForJsSrc(jsExpr, arrayList);
        }
        this.jsExprs.add(jsExpr);
    }

    @Override
    protected void visitCssNode(CssNode cssNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("goog.getCssName(");
        ExprRootNode<?> exprRootNode = cssNode.getComponentNameExpr();
        if (exprRootNode != null) {
            JsExpr jsExpr = this.jsExprTranslator.translateToJsExpr(exprRootNode, cssNode.getComponentNameText(), this.localVarTranslations);
            stringBuilder.append(jsExpr.getText()).append(", ");
        }
        stringBuilder.append("'").append(cssNode.getSelectorText()).append("')");
        this.jsExprs.add(new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode ifNode) {
        GenJsExprsVisitor genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.localVarTranslations);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (SoyNode soyNode : ifNode.getChildren()) {
            Object object;
            AbstractBlockCommandNode abstractBlockCommandNode;
            if (soyNode instanceof IfCondNode) {
                abstractBlockCommandNode = (IfCondNode)soyNode;
                object = this.jsExprTranslator.translateToJsExpr(((IfCondNode)abstractBlockCommandNode).getExprUnion().getExpr(), ((IfCondNode)abstractBlockCommandNode).getExprText(), this.localVarTranslations);
                stringBuilder.append("(").append(((JsExpr)object).getText()).append(") ? ");
                List<JsExpr> list = genJsExprsVisitor.exec(abstractBlockCommandNode);
                stringBuilder.append(JsExprUtils.concatJsExprs(list).getText());
                stringBuilder.append(" : ");
                continue;
            }
            if (soyNode instanceof IfElseNode) {
                bl = true;
                abstractBlockCommandNode = (IfElseNode)soyNode;
                object = genJsExprsVisitor.exec(abstractBlockCommandNode);
                stringBuilder.append(JsExprUtils.concatJsExprs((List<JsExpr>)object).getText());
                continue;
            }
            throw new AssertionError();
        }
        if (!bl) {
            stringBuilder.append("''");
        }
        this.jsExprs.add(new JsExpr(stringBuilder.toString(), Operator.CONDITIONAL.getPrecedence()));
    }

    @Override
    protected void visitIfCondNode(IfCondNode ifCondNode) {
        this.visitChildren(ifCondNode);
    }

    @Override
    protected void visitIfElseNode(IfElseNode ifElseNode) {
        this.visitChildren(ifElseNode);
    }

    @Override
    protected void visitCallNode(CallNode callNode) {
        this.jsExprs.add(this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode callParamContentNode) {
        this.visitChildren(callParamContentNode);
    }

    public static interface GenJsExprsVisitorFactory {
        public GenJsExprsVisitor create(Deque<Map<String, JsExpr>> var1);
    }
}

