/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.TranslateToJsExprVisitor;
import com.google.template.soy.jssrc.internal.V1JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import java.util.Deque;
import java.util.Map;

class JsExprTranslator {
    private final Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap;
    private final SoyJsSrcOptions jsSrcOptions;
    private final TranslateToJsExprVisitor.TranslateToJsExprVisitorFactory translateToJsExprVisitorFactory;

    @Inject
    JsExprTranslator(Map<String, SoyJsSrcFunction> map, SoyJsSrcOptions soyJsSrcOptions, TranslateToJsExprVisitor.TranslateToJsExprVisitorFactory translateToJsExprVisitorFactory) {
        this.soyJsSrcFunctionsMap = map;
        this.jsSrcOptions = soyJsSrcOptions;
        this.translateToJsExprVisitorFactory = translateToJsExprVisitorFactory;
    }

    public JsExpr translateToJsExpr(ExprNode exprNode, String string, Deque<Map<String, JsExpr>> deque) {
        if (exprNode != null && (!this.jsSrcOptions.shouldAllowDeprecatedSyntax() || new CheckAllFunctionsSupportedVisitor(this.soyJsSrcFunctionsMap).exec(exprNode).booleanValue())) {
            return (JsExpr)this.translateToJsExprVisitorFactory.create(deque).exec(exprNode);
        }
        return V1JsExprTranslator.translateToJsExpr(string, deque);
    }

    private static class CheckAllFunctionsSupportedVisitor
    extends AbstractExprNodeVisitor<Boolean> {
        private final Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap;
        private boolean areAllFunctionsSupported;

        public CheckAllFunctionsSupportedVisitor(Map<String, SoyJsSrcFunction> map) {
            this.soyJsSrcFunctionsMap = map;
        }

        @Override
        public Boolean exec(ExprNode exprNode) {
            this.areAllFunctionsSupported = true;
            this.visit(exprNode);
            return this.areAllFunctionsSupported;
        }

        @Override
        protected void visitFunctionNode(FunctionNode functionNode) {
            String string = functionNode.getFunctionName();
            if (NonpluginFunction.forFunctionName(string) == null && !this.soyJsSrcFunctionsMap.containsKey(string)) {
                this.areAllFunctionsSupported = false;
                return;
            }
            this.visitChildren(functionNode);
        }

        @Override
        protected void visitExprNode(ExprNode exprNode) {
            if (exprNode instanceof ExprNode.ParentExprNode) {
                if (!this.areAllFunctionsSupported) {
                    return;
                }
                this.visitChildren((ExprNode.ParentExprNode)exprNode);
            }
        }
    }
}

