/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.MoveGoogMsgNodesEarlierVisitor;
import com.google.template.soy.jssrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.jssrc.internal.ReplaceMsgsWithGoogMsgsVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.IsUsingIjDataVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JsSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<ReplaceMsgsWithGoogMsgsVisitor> replaceMsgsWithGoogMsgsVisitorProvider;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJsCodeVisitor> genJsCodeVisitorProvider;

    @Inject
    public JsSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope guiceSimpleScope, SimplifyVisitor simplifyVisitor, Provider<ReplaceMsgsWithGoogMsgsVisitor> provider, Provider<OptimizeBidiCodeGenVisitor> provider2, Provider<GenJsCodeVisitor> provider3) {
        this.apiCallScope = guiceSimpleScope;
        this.simplifyVisitor = simplifyVisitor;
        this.replaceMsgsWithGoogMsgsVisitorProvider = provider;
        this.optimizeBidiCodeGenVisitorProvider = provider2;
        this.genJsCodeVisitorProvider = provider3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> genJsSrc(SoyFileSetNode soyFileSetNode, SoyJsSrcOptions soyJsSrcOptions, @Nullable SoyMsgBundle soyMsgBundle) throws SoySyntaxException {
        boolean bl = soyJsSrcOptions.isUsingIjData() || new IsUsingIjDataVisitor().exec(soyFileSetNode);
        Preconditions.checkState((!soyJsSrcOptions.getUseGoogIsRtlForBidiGlobalDir() || soyJsSrcOptions.shouldProvideRequireSoyNamespaces() || soyJsSrcOptions.shouldProvideRequireJsFunctions() ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without either shouldProvideRequireSoyNamespaces or shouldProvideRequireJsFunctions.");
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyJsSrcOptions.class, soyJsSrcOptions);
            this.apiCallScope.seed(Key.get(Boolean.class, ApiCallScopeBindingAnnotations.IsUsingIjData.class), Boolean.valueOf(bl));
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromOptions(soyJsSrcOptions.getBidiGlobalDir(), soyJsSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, bidiGlobalDir);
            if (soyJsSrcOptions.shouldGenerateGoogMsgDefs()) {
                ((ReplaceMsgsWithGoogMsgsVisitor)this.replaceMsgsWithGoogMsgsVisitorProvider.get()).exec(soyFileSetNode);
                new MoveGoogMsgNodesEarlierVisitor().exec(soyFileSetNode);
                Preconditions.checkState((bidiGlobalDir != null ? 1 : 0) != 0, (Object)"If enabling shouldGenerateGoogMsgDefs, must also set bidi global directionality.");
            } else {
                Preconditions.checkState((bidiGlobalDir == null || bidiGlobalDir.isStaticValue() ? 1 : 0) != 0, (Object)"If using bidiGlobalIsRtlCodeSnippet, must also enable shouldGenerateGoogMsgDefs.");
                try {
                    new InsertMsgsVisitor(soyMsgBundle, false).exec(soyFileSetNode);
                }
                catch (InsertMsgsVisitor.EncounteredPluralSelectMsgException encounteredPluralSelectMsgException) {
                    throw new SoySyntaxException("JS code generation currently only supports plural/select messages when shouldGenerateGoogMsgDefs is true.");
                }
            }
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyFileSetNode);
            this.simplifyVisitor.exec(soyFileSetNode);
            List<String> list = ((GenJsCodeVisitor)this.genJsCodeVisitorProvider.get()).exec(soyFileSetNode);
            return list;
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyFileSetNode, SoyJsSrcOptions soyJsSrcOptions, @Nullable String string, @Nullable SoyMsgBundle soyMsgBundle, String string2, String string3) throws SoySyntaxException, IOException {
        Object object;
        List<String> list = this.genJsSrc(soyFileSetNode, soyJsSrcOptions, soyMsgBundle);
        int n = soyFileSetNode.numChildren();
        if (n != list.size()) {
            throw new AssertionError();
        }
        ListMultimap listMultimap = Multimaps.newListMultimap((Map)Maps.newLinkedHashMap(), (Supplier)new Supplier<List<Integer>>(){

            public List<Integer> get() {
                return Lists.newArrayList();
            }
        });
        for (int i = 0; i < n; ++i) {
            Object object2 = (SoyFileNode)soyFileSetNode.getChild(i);
            object = ((SoyFileNode)object2).getFilePath();
            String string4 = JsSrcUtils.buildFilePath(string2, string, (String)object, string3);
            BaseUtils.ensureDirsExistInPath(string4);
            listMultimap.put((Object)string4, (Object)i);
        }
        for (Object object2 : listMultimap.keySet()) {
            object = Files.newWriter((File)new File((String)object2), (Charset)Charsets.UTF_8);
            try {
                boolean bl = true;
                Iterator iterator = listMultimap.get(object2).iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    if (bl) {
                        bl = false;
                    } else {
                        ((Writer)object).write("\n;\n");
                    }
                    ((Writer)object).write(list.get(n2));
                }
            }
            finally {
                ((Writer)object).close();
            }
        }
    }
}

