/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.sharedpasses.BuildAllDependeesMapVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.List;
import java.util.Map;

class MoveGoogMsgNodesEarlierVisitor
extends AbstractSoyNodeVisitor<Void> {
    private List<GoogMsgNode> googMsgNodes;

    MoveGoogMsgNodesEarlierVisitor() {
    }

    @Override
    public Void exec(SoyNode soyNode) {
        this.googMsgNodes = Lists.newArrayList();
        this.visit(soyNode);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
        Map<SoyNode, List<SoyNode>> map = new BuildAllDependeesMapVisitor().exec(soyFileSetNode);
        for (GoogMsgNode googMsgNode : this.googMsgNodes) {
            this.moveGoogMsgNodeEarlierHelper(googMsgNode, map.get(googMsgNode));
        }
    }

    @Override
    protected void visitGoogMsgNode(GoogMsgNode googMsgNode) {
        this.googMsgNodes.add(googMsgNode);
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }

    private void moveGoogMsgNodeEarlierHelper(GoogMsgNode googMsgNode, List<SoyNode> list) {
        int n;
        SoyNode.BlockNode blockNode;
        SoyNode soyNode = list.get(0);
        if (soyNode instanceof SoyNode.LocalVarInlineNode) {
            blockNode = (SoyNode.BlockNode)soyNode.getParent();
            n = blockNode.getChildIndex((SoyNode.LocalVarInlineNode)soyNode) + 1;
        } else if (soyNode instanceof SoyNode.BlockNode) {
            blockNode = (SoyNode.BlockNode)soyNode;
            n = 0;
        } else {
            throw new AssertionError();
        }
        List list2 = blockNode.getChildren();
        while (n < list2.size() && list2.get(n) instanceof GoogMsgNode) {
            if (googMsgNode == list2.get(n)) {
                return;
            }
            ++n;
        }
        googMsgNode.getParent().removeChild(googMsgNode);
        blockNode.addChild(n, googMsgNode);
    }
}

