/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class TranslateToJsExprVisitor
extends AbstractReturningExprNodeVisitor<JsExpr> {
    private final Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap;
    private final Deque<Map<String, JsExpr>> localVarTranslations;
    private static final ImmutableSet<String> JS_RESERVED_WORDS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"catch", (Object)"class", (Object)"const", (Object)"continue", (Object[])new String[]{"debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "null", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "yield"});

    @AssistedInject
    TranslateToJsExprVisitor(Map<String, SoyJsSrcFunction> map, @Assisted Deque<Map<String, JsExpr>> deque) {
        this.soyJsSrcFunctionsMap = map;
        this.localVarTranslations = deque;
    }

    @Override
    protected JsExpr visitExprRootNode(ExprRootNode<?> exprRootNode) {
        return (JsExpr)this.visit((ExprNode)exprRootNode.getChild(0));
    }

    @Override
    protected JsExpr visitStringNode(StringNode stringNode) {
        return new JsExpr(JsSrcUtils.escapeUnicodeFormatChars(stringNode.toSourceString()), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitPrimitiveNode(ExprNode.PrimitiveNode primitiveNode) {
        return new JsExpr(primitiveNode.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitListLiteralNode(ListLiteralNode listLiteralNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        boolean bl = true;
        for (ExprNode exprNode : listLiteralNode.getChildren()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((JsExpr)this.visit(exprNode)).getText());
        }
        stringBuilder.append("]");
        return new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitMapLiteralNode(MapLiteralNode mapLiteralNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        int n = mapLiteralNode.numChildren();
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((JsExpr)this.visit(mapLiteralNode.getChild(i))).getText()).append(": ").append(((JsExpr)this.visit(mapLiteralNode.getChild(i + 1))).getText());
        }
        stringBuilder.append("}");
        return new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitDataRefNode(DataRefNode dataRefNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = dataRefNode.getFirstKey();
        if (dataRefNode.isIjDataRef()) {
            stringBuilder.append("opt_ijData");
            this.appendDataRefKey(stringBuilder, string);
        } else {
            JsExpr jsExpr = this.getLocalVarTranslation(string);
            if (jsExpr != null) {
                stringBuilder.append(jsExpr.getText());
            } else {
                stringBuilder.append("opt_data");
                this.appendDataRefKey(stringBuilder, string);
            }
        }
        int n = dataRefNode.numChildren();
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                ExprNode exprNode = dataRefNode.getChild(i);
                if (exprNode instanceof DataRefKeyNode) {
                    this.appendDataRefKey(stringBuilder, ((DataRefKeyNode)exprNode).getKey());
                    continue;
                }
                if (exprNode instanceof DataRefIndexNode) {
                    stringBuilder.append("[").append(((DataRefIndexNode)exprNode).getIndex()).append("]");
                    continue;
                }
                JsExpr jsExpr = (JsExpr)this.visit(exprNode);
                stringBuilder.append("[").append(jsExpr.getText()).append("]");
            }
        }
        return new JsExpr(stringBuilder.toString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitGlobalNode(GlobalNode globalNode) {
        return new JsExpr(globalNode.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected JsExpr visitNotOpNode(OperatorNodes.NotOpNode notOpNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(notOpNode, "!");
    }

    @Override
    protected JsExpr visitAndOpNode(OperatorNodes.AndOpNode andOpNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(andOpNode, "&&");
    }

    @Override
    protected JsExpr visitOrOpNode(OperatorNodes.OrOpNode orOpNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(orOpNode, "||");
    }

    @Override
    protected JsExpr visitOperatorNode(ExprNode.OperatorNode operatorNode) {
        return this.genJsExprUsingSoySyntax(operatorNode);
    }

    @Override
    protected JsExpr visitFunctionNode(FunctionNode functionNode) {
        String string = functionNode.getFunctionName();
        int n = functionNode.numChildren();
        NonpluginFunction nonpluginFunction = NonpluginFunction.forFunctionName(string);
        if (nonpluginFunction != null) {
            if (n != nonpluginFunction.getNumArgs()) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            switch (nonpluginFunction) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(functionNode);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(functionNode);
                }
                case INDEX: {
                    return this.visitIndexFunction(functionNode);
                }
                case HAS_DATA: {
                    return this.visitHasDataFunction();
                }
            }
            throw new AssertionError();
        }
        SoyJsSrcFunction soyJsSrcFunction = this.soyJsSrcFunctionsMap.get(string);
        if (soyJsSrcFunction != null) {
            if (!soyJsSrcFunction.getValidArgsSizes().contains(n)) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            List<JsExpr> list = this.visitChildren(functionNode);
            try {
                return soyJsSrcFunction.computeForJsSrc(list);
            }
            catch (Exception exception) {
                throw new SoySyntaxException("Error in function call \"" + functionNode.toSourceString() + "\": " + exception.getMessage(), exception);
            }
        }
        throw new SoySyntaxException("Failed to find SoyJsSrcFunction with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
    }

    private JsExpr visitIsFirstFunction(FunctionNode functionNode) {
        String string = ((DataRefNode)functionNode.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(string + "__isFirst");
    }

    private JsExpr visitIsLastFunction(FunctionNode functionNode) {
        String string = ((DataRefNode)functionNode.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(string + "__isLast");
    }

    private JsExpr visitIndexFunction(FunctionNode functionNode) {
        String string = ((DataRefNode)functionNode.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(string + "__index");
    }

    private JsExpr visitHasDataFunction() {
        return new JsExpr("opt_data != null", Operator.NOT_EQUAL.getPrecedence());
    }

    private JsExpr getLocalVarTranslation(String string) {
        for (Map<String, JsExpr> map : this.localVarTranslations) {
            JsExpr jsExpr = map.get(string);
            if (jsExpr == null) continue;
            return jsExpr;
        }
        return null;
    }

    private JsExpr genJsExprUsingSoySyntax(ExprNode.OperatorNode operatorNode) {
        return this.genJsExprUsingSoySyntaxWithNewToken(operatorNode, null);
    }

    private JsExpr genJsExprUsingSoySyntaxWithNewToken(ExprNode.OperatorNode operatorNode, String string) {
        List<JsExpr> list = this.visitChildren(operatorNode);
        return SoyJsCodeUtils.genJsExprUsingSoySyntaxWithNewToken(operatorNode.getOperator(), list, string);
    }

    private void appendDataRefKey(StringBuilder stringBuilder, String string) {
        if (JS_RESERVED_WORDS.contains((Object)string)) {
            stringBuilder.append("['").append(string).append("']");
        } else {
            stringBuilder.append(".").append(string);
        }
    }

    public static interface TranslateToJsExprVisitorFactory {
        public TranslateToJsExprVisitor create(Deque<Map<String, JsExpr>> var1);
    }
}

