/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Deque;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class V1JsExprTranslator {
    public static final String VAR_OR_REF_RE = "\\$([a-zA-Z0-9_]+)((?:\\.[a-zA-Z0-9_]+)*)";
    public static final Pattern VAR_OR_REF = Pattern.compile("\\$([a-zA-Z0-9_]+)((?:\\.[a-zA-Z0-9_]+)*)");
    private static final String SOY_FUNCTION_RE = "(isFirst|isLast|index)\\(\\s*\\$([a-zA-Z0-9_]+)\\s*\\)";
    private static final Pattern SOY_FUNCTION = Pattern.compile("(isFirst|isLast|index)\\(\\s*\\$([a-zA-Z0-9_]+)\\s*\\)");
    private static final Pattern BOOL_OP_RE = Pattern.compile("\\b(not|and|or)\\b");
    private static final Pattern VAR_OR_REF_OR_BOOL_OP_OR_SOY_FUNCTION = Pattern.compile("\\$([a-zA-Z0-9_]+)((?:\\.[a-zA-Z0-9_]+)*)|" + BOOL_OP_RE + "|" + "(isFirst|isLast|index)\\(\\s*\\$([a-zA-Z0-9_]+)\\s*\\)");
    private static final Pattern NUMBER = Pattern.compile("[0-9]+");
    private static final Pattern OP_TOKEN_CHAR = Pattern.compile("[-?|&=!<>+*/%]");

    V1JsExprTranslator() {
    }

    public static JsExpr translateToJsExpr(String string, Deque<Map<String, JsExpr>> deque) throws SoySyntaxException {
        String string2;
        string = CharMatcher.WHITESPACE.collapseFrom((CharSequence)string, ' ');
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = VAR_OR_REF_OR_BOOL_OP_OR_SOY_FUNCTION.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
            if (VAR_OR_REF.matcher(string2).matches()) {
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(V1JsExprTranslator.translateVarOrRef(string2, deque)));
                continue;
            }
            if (BOOL_OP_RE.matcher(string2).matches()) {
                matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(V1JsExprTranslator.translateBoolOp(string2)));
                continue;
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(V1JsExprTranslator.translateFunction(string2, deque)));
        }
        matcher.appendTail(stringBuffer);
        string2 = stringBuffer.toString();
        string2 = JsSrcUtils.escapeUnicodeFormatChars(string2);
        int n = V1JsExprTranslator.guessJsExprPrecedence(string2);
        return new JsExpr(string2, n);
    }

    private static String translateVarOrRef(String string, Deque<Map<String, JsExpr>> deque) throws SoySyntaxException {
        Matcher matcher = VAR_OR_REF.matcher(string);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Variable or data reference \"" + string + "\" is malformed.");
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = V1JsExprTranslator.getLocalVarTranslation(string2, deque);
        if (string4 != null) {
            stringBuilder.append(string4);
        } else {
            stringBuilder.append("opt_data.").append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            for (String string5 : Splitter.on((char)'.').split((CharSequence)string3.substring(1))) {
                if (NUMBER.matcher(string5).matches()) {
                    stringBuilder.append("[").append(string5).append("]");
                    continue;
                }
                stringBuilder.append(".").append(string5);
            }
        }
        return stringBuilder.toString();
    }

    private static String translateBoolOp(String string) {
        if (string.equals("not")) {
            return "!";
        }
        if (string.equals("and")) {
            return "&&";
        }
        if (string.equals("or")) {
            return "||";
        }
        throw new AssertionError();
    }

    private static String translateFunction(String string, Deque<Map<String, JsExpr>> deque) throws SoySyntaxException {
        Matcher matcher = SOY_FUNCTION.matcher(string);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Soy function call \"" + string + "\" is malformed.");
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        return V1JsExprTranslator.getLocalVarTranslation(string3 + "__" + string2, deque);
    }

    private static int guessJsExprPrecedence(String string) {
        int n = Integer.MAX_VALUE;
        Matcher matcher = OP_TOKEN_CHAR.matcher(string);
        block11: while (matcher.find()) {
            switch (matcher.group().charAt(0)) {
                case '?': {
                    n = Math.min(n, Operator.CONDITIONAL.getPrecedence());
                    continue block11;
                }
                case '|': {
                    n = Math.min(n, Operator.OR.getPrecedence());
                    continue block11;
                }
                case '&': {
                    n = Math.min(n, Operator.AND.getPrecedence());
                    continue block11;
                }
                case '=': {
                    n = Math.min(n, Operator.EQUAL.getPrecedence());
                    continue block11;
                }
                case '!': {
                    if (string.contains("!=")) {
                        n = Math.min(n, Operator.NOT_EQUAL.getPrecedence());
                        continue block11;
                    }
                    n = Math.min(n, Operator.NOT.getPrecedence());
                    continue block11;
                }
                case '<': 
                case '>': {
                    n = Math.min(n, Operator.LESS_THAN.getPrecedence());
                    continue block11;
                }
                case '+': {
                    n = Math.min(n, Operator.PLUS.getPrecedence());
                    continue block11;
                }
                case '-': {
                    if (matcher.start() == 0) {
                        n = Math.min(n, Operator.NEGATIVE.getPrecedence());
                        continue block11;
                    }
                    n = Math.min(n, Operator.MINUS.getPrecedence());
                    continue block11;
                }
                case '%': 
                case '*': 
                case '/': {
                    n = Math.min(n, Operator.TIMES.getPrecedence());
                    continue block11;
                }
            }
            throw new AssertionError();
        }
        return n;
    }

    private static String getLocalVarTranslation(String string, Deque<Map<String, JsExpr>> deque) {
        for (Map<String, JsExpr> map : deque) {
            JsExpr jsExpr = map.get(string);
            if (jsExpr == null) continue;
            if (jsExpr.getPrecedence() != Integer.MAX_VALUE) {
                return "(" + jsExpr.getText() + ")";
            }
            return jsExpr.getText();
        }
        return null;
    }
}

