/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgException;
import com.google.template.soy.msgs.SoyMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class SoyMsgBundleHandler {
    private static final Pattern FIRST_WORD_IS_EN_PATTERN = Pattern.compile("^en[^A-Za-z].*");
    private final SoyMsgPlugin msgPlugin;

    @Inject
    public SoyMsgBundleHandler(SoyMsgPlugin soyMsgPlugin) {
        this.msgPlugin = soyMsgPlugin;
    }

    public void writeToFile(SoyMsgBundle soyMsgBundle, File file) throws IOException, SoyMsgException {
        this.writeToFile(soyMsgBundle, new OutputFileOptions(), file);
    }

    public void writeToFile(SoyMsgBundle soyMsgBundle, OutputFileOptions outputFileOptions, File file) throws IOException, SoyMsgException {
        CharSequence charSequence = this.msgPlugin.generateExtractedMsgsFile(soyMsgBundle, outputFileOptions);
        BaseUtils.ensureDirsExistInPath(file.getPath());
        Files.write((CharSequence)charSequence, (File)file, (Charset)Charsets.UTF_8);
    }

    public SoyMsgBundle createFromFile(File file) throws IOException, SoyMsgException {
        if (!file.exists() && FIRST_WORD_IS_EN_PATTERN.matcher(file.getName()).matches()) {
            return SoyMsgBundle.EMPTY;
        }
        try {
            String string = Files.toString((File)file, (Charset)Charsets.UTF_8);
            return this.msgPlugin.parseTranslatedMsgsFile(string);
        }
        catch (SoyMsgException soyMsgException) {
            soyMsgException.setFileOrResourceName(file.toString());
            throw soyMsgException;
        }
    }

    public SoyMsgBundle createFromResource(URL uRL) throws IOException, SoyMsgException {
        try {
            String string = Resources.toString((URL)uRL, (Charset)Charsets.UTF_8);
            return this.msgPlugin.parseTranslatedMsgsFile(string);
        }
        catch (SoyMsgException soyMsgException) {
            soyMsgException.setFileOrResourceName(uRL.toString());
            throw soyMsgException;
        }
    }

    public static class OutputFileOptions {
        private String sourceLocaleString = "en";
        private String targetLocaleString = null;

        public void setSourceLocaleString(String string) {
            this.sourceLocaleString = string;
        }

        public String getSourceLocaleString() {
            return this.sourceLocaleString;
        }

        public void setTargetLocaleString(String string) {
            this.targetLocaleString = string;
        }

        public String getTargetLocaleString() {
            return this.targetLocaleString;
        }
    }
}

