/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.restricted.SoyMsgIdComputer;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgPluralRemainderNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;

public class MsgUtils {
    private MsgUtils() {
    }

    public static Pair<List<SoyMsgPart>, Long> buildMsgPartsAndComputeMsgId(MsgNode msgNode) {
        List<SoyMsgPart> list = MsgUtils.buildMsgParts(msgNode);
        long l = SoyMsgIdComputer.computeMsgId(list, msgNode.getMeaning(), msgNode.getContentType());
        return Pair.of(list, l);
    }

    public static List<SoyMsgPart> buildMsgParts(MsgNode msgNode) {
        return MsgUtils.buildMsgPartsForChildren(msgNode, msgNode);
    }

    private static List<SoyMsgPart> buildMsgPartsForChildren(SoyNode.BlockNode blockNode, MsgNode msgNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode.StandaloneNode standaloneNode : blockNode.getChildren()) {
            String string;
            if (standaloneNode instanceof RawTextNode) {
                string = ((RawTextNode)standaloneNode).getRawText();
                arrayList.add(new SoyMsgRawTextPart(string));
                continue;
            }
            if (standaloneNode instanceof MsgPlaceholderNode) {
                string = msgNode.getPlaceholderName((MsgPlaceholderNode)standaloneNode);
                arrayList.add(new SoyMsgPlaceholderPart(string));
                continue;
            }
            if (standaloneNode instanceof MsgPluralRemainderNode) {
                arrayList.add(new SoyMsgPluralRemainderPart(msgNode.getPluralVarName(standaloneNode.getNearestAncestor(MsgPluralNode.class))));
                continue;
            }
            if (standaloneNode instanceof MsgPluralNode) {
                arrayList.add(MsgUtils.buildMsgPartForPlural((MsgPluralNode)standaloneNode, msgNode));
                continue;
            }
            if (!(standaloneNode instanceof MsgSelectNode)) continue;
            arrayList.add(MsgUtils.buildMsgPartForSelect((MsgSelectNode)standaloneNode, msgNode));
        }
        return arrayList;
    }

    private static SoyMsgPluralPart buildMsgPartForPlural(MsgPluralNode msgPluralNode, MsgNode msgNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (CaseOrDefaultNode caseOrDefaultNode : msgPluralNode.getChildren()) {
            SoyMsgPluralCaseSpec soyMsgPluralCaseSpec;
            List<SoyMsgPart> list = MsgUtils.buildMsgPartsForChildren(caseOrDefaultNode, msgNode);
            if (caseOrDefaultNode instanceof MsgPluralCaseNode) {
                soyMsgPluralCaseSpec = new SoyMsgPluralCaseSpec(((MsgPluralCaseNode)caseOrDefaultNode).getCaseNumber());
            } else if (caseOrDefaultNode instanceof MsgPluralDefaultNode) {
                soyMsgPluralCaseSpec = new SoyMsgPluralCaseSpec("other");
            } else {
                throw new AssertionError((Object)"Unidentified node under a plural node.");
            }
            arrayList.add(Pair.of(soyMsgPluralCaseSpec, list));
        }
        return new SoyMsgPluralPart(msgNode.getPluralVarName(msgPluralNode), msgPluralNode.getOffset(), arrayList);
    }

    private static SoyMsgSelectPart buildMsgPartForSelect(MsgSelectNode msgSelectNode, MsgNode msgNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (CaseOrDefaultNode caseOrDefaultNode : msgSelectNode.getChildren()) {
            String string;
            List<SoyMsgPart> list = MsgUtils.buildMsgPartsForChildren(caseOrDefaultNode, msgNode);
            if (caseOrDefaultNode instanceof MsgSelectCaseNode) {
                string = ((MsgSelectCaseNode)caseOrDefaultNode).getCaseValue();
            } else if (caseOrDefaultNode instanceof MsgSelectDefaultNode) {
                string = null;
            } else {
                throw new AssertionError((Object)"Unidentified node under a select node.");
            }
            arrayList.add(Pair.of(string, list));
        }
        return new SoyMsgSelectPart(msgNode.getSelectVarName(msgSelectNode), arrayList);
    }

    public static long computeMsgId(MsgNode msgNode) {
        return SoyMsgIdComputer.computeMsgId(MsgUtils.buildMsgParts(msgNode), msgNode.getMeaning(), msgNode.getContentType());
    }
}

