/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SoyMsg {
    private final long id;
    private final String localeString;
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    private final String contentType;
    private Set<String> sourcePaths;
    private final List<SoyMsgPart> parts;

    public SoyMsg(long l, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl, @Nullable String string4, @Nullable String string5, List<SoyMsgPart> list) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0);
        this.id = l;
        this.localeString = string;
        this.meaning = string2;
        this.desc = string3;
        this.isHidden = bl;
        this.contentType = string4;
        this.sourcePaths = Sets.newHashSetWithExpectedSize((int)1);
        if (string5 != null) {
            this.sourcePaths.add(string5);
        }
        this.parts = ImmutableList.copyOf(list);
    }

    public String getLocaleString() {
        return this.localeString;
    }

    public long getId() {
        return this.id;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void addSourcePath(String string) {
        this.sourcePaths.add(string);
    }

    public Set<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public List<SoyMsgPart> getParts() {
        return this.parts;
    }
}

