/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.restricted.IcuSyntaxUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import java.util.List;
import javax.annotation.Nullable;

public class SoyMsgIdComputer {
    private SoyMsgIdComputer() {
    }

    public static long computeMsgId(List<SoyMsgPart> list, @Nullable String string, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        SoyMsgIdComputer.appendMsgPartsToTcStringBuilder(stringBuilder, list);
        long l = SoyMsgIdComputer.fingerprint(stringBuilder.toString());
        if (string != null) {
            l = (l << 1) + (long)(l < 0L ? 1 : 0) + SoyMsgIdComputer.fingerprint(string);
        }
        if (string2 != null && !string2.equals("text/html")) {
            l = (l << 1) + (long)(l < 0L ? 1 : 0) + SoyMsgIdComputer.fingerprint(string2);
        }
        return l & Long.MAX_VALUE;
    }

    private static void appendMsgPartsToTcStringBuilder(StringBuilder stringBuilder, List<SoyMsgPart> list) {
        for (SoyMsgPart soyMsgPart : list) {
            if (soyMsgPart instanceof SoyMsgRawTextPart) {
                stringBuilder.append(((SoyMsgRawTextPart)soyMsgPart).getRawText());
                continue;
            }
            if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                stringBuilder.append(((SoyMsgPlaceholderPart)soyMsgPart).getPlaceholderName());
                continue;
            }
            if (soyMsgPart instanceof SoyMsgPluralRemainderPart) {
                stringBuilder.append(IcuSyntaxUtils.getPluralRemainderString());
                continue;
            }
            if (soyMsgPart instanceof SoyMsgPluralPart) {
                SoyMsgIdComputer.appendPluralToStringBuilder(stringBuilder, (SoyMsgPluralPart)soyMsgPart);
                continue;
            }
            if (!(soyMsgPart instanceof SoyMsgSelectPart)) continue;
            SoyMsgIdComputer.appendSelectToStringBuilder(stringBuilder, (SoyMsgSelectPart)soyMsgPart);
        }
    }

    private static void appendPluralToStringBuilder(StringBuilder stringBuilder, SoyMsgPluralPart soyMsgPluralPart) {
        stringBuilder.append(IcuSyntaxUtils.getPluralOpenString(soyMsgPluralPart.getPluralVarName(), soyMsgPluralPart.getOffset()));
        for (Pair<SoyMsgPluralCaseSpec, List<SoyMsgPart>> pair : soyMsgPluralPart.getCases()) {
            SoyMsgPluralCaseSpec soyMsgPluralCaseSpec = (SoyMsgPluralCaseSpec)pair.first;
            stringBuilder.append(IcuSyntaxUtils.getPluralCaseOpenString(soyMsgPluralCaseSpec.getType() == SoyMsgPluralCaseSpec.Type.OTHER ? null : Integer.valueOf(soyMsgPluralCaseSpec.getExplicitValue())));
            SoyMsgIdComputer.appendMsgPartsToTcStringBuilder(stringBuilder, (List)pair.second);
            stringBuilder.append(IcuSyntaxUtils.getPluralCaseCloseString());
        }
        stringBuilder.append(IcuSyntaxUtils.getPluralCloseString());
    }

    private static void appendSelectToStringBuilder(StringBuilder stringBuilder, SoyMsgSelectPart soyMsgSelectPart) {
        stringBuilder.append(IcuSyntaxUtils.getSelectOpenString(soyMsgSelectPart.getSelectVarName()));
        for (Pair<String, List<SoyMsgPart>> pair : soyMsgSelectPart.getCases()) {
            stringBuilder.append(IcuSyntaxUtils.getSelectCaseOpenString((String)pair.first));
            SoyMsgIdComputer.appendMsgPartsToTcStringBuilder(stringBuilder, (List)pair.second);
            stringBuilder.append(IcuSyntaxUtils.getSelectCaseCloseString());
        }
        stringBuilder.append(IcuSyntaxUtils.getSelectCloseString());
    }

    @VisibleForTesting
    static long fingerprint(String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        int n = SoyMsgIdComputer.hash32(byArray, 0, byArray.length, 0);
        int n2 = SoyMsgIdComputer.hash32(byArray, 0, byArray.length, 102072);
        if (n == 0 && (n2 == 0 || n2 == 1)) {
            n ^= 0x130F9BEF;
            n2 ^= 0x94A0A928;
        }
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private static int hash32(byte[] byArray, int n, int n2, int n3) {
        int n4 = -1640531527;
        int n5 = -1640531527;
        int n6 = n;
        while (n6 + 12 <= n2) {
            n4 += (byArray[n6 + 0] & 0xFF) << 0 | (byArray[n6 + 1] & 0xFF) << 8 | (byArray[n6 + 2] & 0xFF) << 16 | (byArray[n6 + 3] & 0xFF) << 24;
            n4 -= (n5 += (byArray[n6 + 4] & 0xFF) << 0 | (byArray[n6 + 5] & 0xFF) << 8 | (byArray[n6 + 6] & 0xFF) << 16 | (byArray[n6 + 7] & 0xFF) << 24);
            n4 -= (n3 += (byArray[n6 + 8] & 0xFF) << 0 | (byArray[n6 + 9] & 0xFF) << 8 | (byArray[n6 + 10] & 0xFF) << 16 | (byArray[n6 + 11] & 0xFF) << 24);
            n5 -= n3;
            n5 -= (n4 ^= n3 >>> 13);
            n3 -= n4;
            n3 -= (n5 ^= n4 << 8);
            n4 -= n5;
            n4 -= (n3 ^= n5 >>> 13);
            n5 -= n3;
            n5 -= (n4 ^= n3 >>> 12);
            n3 -= n4;
            n3 -= (n5 ^= n4 << 16);
            n4 -= n5;
            n4 -= (n3 ^= n5 >>> 5);
            n5 -= n3;
            n5 -= (n4 ^= n3 >>> 3);
            n3 -= n4;
            n3 -= (n5 ^= n4 << 10);
            n3 ^= n5 >>> 15;
            n6 += 12;
        }
        n3 += n2 - n;
        switch (n2 - n6) {
            case 11: {
                n3 += (byArray[n6 + 10] & 0xFF) << 24;
            }
            case 10: {
                n3 += (byArray[n6 + 9] & 0xFF) << 16;
            }
            case 9: {
                n3 += (byArray[n6 + 8] & 0xFF) << 8;
            }
            case 8: {
                n5 += (byArray[n6 + 7] & 0xFF) << 24;
            }
            case 7: {
                n5 += (byArray[n6 + 6] & 0xFF) << 16;
            }
            case 6: {
                n5 += (byArray[n6 + 5] & 0xFF) << 8;
            }
            case 5: {
                n5 += byArray[n6 + 4] & 0xFF;
            }
            case 4: {
                n4 += (byArray[n6 + 3] & 0xFF) << 24;
            }
            case 3: {
                n4 += (byArray[n6 + 2] & 0xFF) << 16;
            }
            case 2: {
                n4 += (byArray[n6 + 1] & 0xFF) << 8;
            }
            case 1: {
                n4 += byArray[n6 + 0] & 0xFF;
            }
        }
        n4 -= n5;
        n4 -= n3;
        n5 -= n3;
        n5 -= (n4 ^= n3 >>> 13);
        n3 -= n4;
        n3 -= (n5 ^= n4 << 8);
        n4 -= n5;
        n4 -= (n3 ^= n5 >>> 13);
        n5 -= n3;
        n5 -= (n4 ^= n3 >>> 12);
        n3 -= n4;
        n3 -= (n5 ^= n4 << 16);
        n4 -= n5;
        n4 -= (n3 ^= n5 >>> 5);
        n5 -= n3;
        n5 -= (n4 ^= n3 >>> 3);
        n3 -= n4;
        n3 -= (n5 ^= n4 << 10);
        return n3 ^= n5 >>> 15;
    }
}

