/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;

public class CheckOverridesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private Map<String, TemplateBasicNode> basicTemplatesMap;

    @Override
    public Void exec(SoyNode soyNode) {
        this.basicTemplatesMap = Maps.newHashMap();
        this.visit(soyNode);
        return null;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFileNode) {
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitTemplateBasicNode(TemplateBasicNode templateBasicNode) {
        String string = templateBasicNode.getTemplateName();
        Preconditions.checkArgument((string.charAt(0) != '.' ? 1 : 0) != 0);
        if (this.basicTemplatesMap.containsKey(string)) {
            TemplateNode templateNode = this.basicTemplatesMap.get(string);
            if (!templateBasicNode.isOverride()) {
                SoyFileNode soyFileNode = templateNode.getNearestAncestor(SoyFileNode.class);
                SoyFileNode soyFileNode2 = templateBasicNode.getNearestAncestor(SoyFileNode.class);
                if (soyFileNode2 == soyFileNode) {
                    throw new SoySyntaxException("Found two definitions for template name '" + string + "', both in the file " + soyFileNode2.getFilePath() + ".");
                }
                String string2 = soyFileNode.getFilePath();
                String string3 = soyFileNode2.getFilePath();
                if (string3.equals(string2)) {
                    throw new SoySyntaxException("Found two definitions for template name '" + string + "' in two different files with the same name " + string3 + " (perhaps the file was accidentally included twice).");
                }
                throw new SoySyntaxException("Found two definitions for template name '" + string + "' in two different files " + string2 + " and " + string3 + ".");
            }
        } else {
            this.basicTemplatesMap.put(string, templateBasicNode);
        }
    }

    @Override
    protected void visitTemplateDelegateNode(TemplateDelegateNode templateDelegateNode) {
    }
}

