/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.coredirectives.NoAutoescapeDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;

public class PerformAutoescapeVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final Map<String, SoyPrintDirective> soyDirectivesMap;
    private IdGenerator nodeIdGen;
    private boolean currTemplateShouldAutoescape;

    @Inject
    public PerformAutoescapeVisitor(Map<String, SoyPrintDirective> map) {
        this.soyDirectivesMap = map;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode soyFileSetNode) {
        this.nodeIdGen = soyFileSetNode.getNodeIdGenerator();
        this.visitChildren(soyFileSetNode);
    }

    @Override
    protected void visitTemplateNode(TemplateNode templateNode) {
        this.currTemplateShouldAutoescape = templateNode.getAutoescapeMode() != AutoescapeMode.FALSE;
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitPrintNode(PrintNode printNode) {
        boolean bl = false;
        for (PrintDirectiveNode printDirectiveNode : Lists.newArrayList(printNode.getChildren())) {
            SoyPrintDirective soyPrintDirective = this.soyDirectivesMap.get(printDirectiveNode.getName());
            if (soyPrintDirective == null) {
                throw new SoySyntaxException("Failed to find SoyPrintDirective with name '" + printDirectiveNode.getName() + "'" + " (tag " + printNode.toSourceString() + ")");
            }
            if (!soyPrintDirective.shouldCancelAutoescape()) continue;
            bl = true;
            if (!(soyPrintDirective instanceof NoAutoescapeDirective)) continue;
            printNode.removeChild(printDirectiveNode);
        }
        if (this.currTemplateShouldAutoescape && !bl) {
            PrintDirectiveNode printDirectiveNode = new PrintDirectiveNode(this.nodeIdGen.genId(), "|escapeHtml", "");
            printNode.addChild(0, printDirectiveNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode soyNode) {
        if (soyNode instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)soyNode);
        }
    }
}

