/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.parsepasses.contextautoesc.EscapingMode;
import java.util.List;
import javax.annotation.Nullable;

public final class Context {
    public final State state;
    public final ElementType elType;
    public final AttributeType attrType;
    public final AttributeEndDelimiter delimType;
    public final JsFollowingSlash slashType;
    public final UriPart uriPart;
    public static final Context HTML_PCDATA = new Context(State.HTML_PCDATA);
    public static final Context HTML_COMMENT = new Context(State.HTML_COMMENT);
    public static final Context HTML_BEFORE_TAG_NAME = new Context(State.HTML_BEFORE_TAG_NAME);
    public static final Context HTML_TAG_NAME = new Context(State.HTML_TAG_NAME);
    public static final Context CSS = new Context(State.CSS);
    public static final Context JS = new Context(State.JS).derive(JsFollowingSlash.REGEX);
    public static final Context ERROR = new Context(State.ERROR);
    private static final int N_STATE_BITS = 5;
    private static final int N_ELEMENT_BITS = 3;
    private static final int N_ATTR_BITS = 3;
    private static final int N_DELIM_BITS = 2;
    private static final int N_JS_SLASH_BITS = 2;
    private static final int N_URI_PART_BITS = 3;

    public Context(State state, ElementType elementType, AttributeType attributeType, AttributeEndDelimiter attributeEndDelimiter, JsFollowingSlash jsFollowingSlash, UriPart uriPart) {
        this.state = state;
        this.elType = elementType;
        this.attrType = attributeType;
        this.delimType = attributeEndDelimiter;
        this.slashType = jsFollowingSlash;
        this.uriPart = uriPart;
    }

    public Context(State state) {
        this(state, ElementType.NONE, AttributeType.NONE, AttributeEndDelimiter.NONE, JsFollowingSlash.NONE, UriPart.NONE);
    }

    public Context derive(State state) {
        return state == this.state ? this : new Context(state, this.elType, this.attrType, this.delimType, this.slashType, this.uriPart);
    }

    public Context derive(ElementType elementType) {
        return elementType == this.elType ? this : new Context(this.state, elementType, this.attrType, this.delimType, this.slashType, this.uriPart);
    }

    public Context derive(AttributeType attributeType) {
        return attributeType == this.attrType ? this : new Context(this.state, this.elType, attributeType, this.delimType, this.slashType, this.uriPart);
    }

    public Context derive(AttributeEndDelimiter attributeEndDelimiter) {
        return attributeEndDelimiter == this.delimType ? this : new Context(this.state, this.elType, this.attrType, attributeEndDelimiter, this.slashType, this.uriPart);
    }

    public Context derive(JsFollowingSlash jsFollowingSlash) {
        return jsFollowingSlash == this.slashType ? this : new Context(this.state, this.elType, this.attrType, this.delimType, jsFollowingSlash, this.uriPart);
    }

    public Context derive(UriPart uriPart) {
        return uriPart == this.uriPart ? this : new Context(this.state, this.elType, this.attrType, this.delimType, this.slashType, uriPart);
    }

    public Context getContextAfterEscaping(@Nullable EscapingMode escapingMode) {
        if (escapingMode == null) {
            return ERROR;
        }
        if (escapingMode == EscapingMode.ESCAPE_JS_VALUE) {
            switch (this.slashType) {
                case DIV_OP: 
                case UNKNOWN: {
                    return this;
                }
                case REGEX: {
                    return this.derive(JsFollowingSlash.DIV_OP);
                }
            }
            throw new IllegalStateException(this.slashType.name());
        }
        if (this.state == State.HTML_BEFORE_TAG_NAME) {
            return HTML_TAG_NAME;
        }
        if (this.state == State.HTML_TAG) {
            return new Context(State.HTML_ATTRIBUTE_NAME, this.elType, AttributeType.PLAIN_TEXT, this.delimType, this.slashType, this.uriPart);
        }
        if (this.uriPart == UriPart.START) {
            return this.derive(UriPart.PRE_QUERY);
        }
        return this;
    }

    Context getContextBeforeDynamicValue() {
        if (this.state == State.HTML_BEFORE_ATTRIBUTE_VALUE) {
            return Context.computeContextAfterAttributeDelimiter(this.elType, this.attrType, AttributeEndDelimiter.SPACE_OR_TAG_END);
        }
        return this;
    }

    static Context computeContextAfterAttributeDelimiter(ElementType elementType, AttributeType attributeType, AttributeEndDelimiter attributeEndDelimiter) {
        State state;
        JsFollowingSlash jsFollowingSlash = JsFollowingSlash.NONE;
        UriPart uriPart = UriPart.NONE;
        switch (attributeType) {
            case PLAIN_TEXT: {
                state = State.HTML_NORMAL_ATTR_VALUE;
                break;
            }
            case SCRIPT: {
                state = State.JS;
                jsFollowingSlash = JsFollowingSlash.REGEX;
                break;
            }
            case STYLE: {
                state = State.CSS;
                break;
            }
            case URI: {
                state = State.URI;
                uriPart = UriPart.START;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected attribute type " + (Object)((Object)attributeType)));
            }
        }
        return new Context(state, elementType, attributeType, attributeEndDelimiter, jsFollowingSlash, uriPart);
    }

    @Nullable
    public List<EscapingMode> getEscapingModes() {
        EscapingMode escapingMode = this.state.escapingMode;
        if (escapingMode == null) {
            return ImmutableList.of();
        }
        EscapingMode escapingMode2 = null;
        switch (this.uriPart) {
            case QUERY: {
                escapingMode = EscapingMode.ESCAPE_URI;
                break;
            }
            case START: {
                if (escapingMode != EscapingMode.NORMALIZE_URI) {
                    escapingMode2 = escapingMode;
                }
                escapingMode = EscapingMode.FILTER_NORMALIZE_URI;
                break;
            }
            case UNKNOWN: 
            case UNKNOWN_PRE_FRAGMENT: {
                return ImmutableList.of();
            }
        }
        switch (this.delimType) {
            case SPACE_OR_TAG_END: {
                if (escapingMode == EscapingMode.ESCAPE_HTML_ATTRIBUTE) {
                    escapingMode = EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE;
                    break;
                }
                escapingMode2 = EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE;
                break;
            }
            case SINGLE_QUOTE: {
                if (escapingMode.isHtmlEmbeddable) break;
                escapingMode2 = EscapingMode.ESCAPE_HTML_ATTRIBUTE;
                break;
            }
        }
        return escapingMode2 == null ? ImmutableList.of((Object)((Object)escapingMode)) : ImmutableList.of((Object)((Object)escapingMode), (Object)((Object)escapingMode2));
    }

    public boolean isCompatibleWith(EscapingMode escapingMode) {
        if (escapingMode == EscapingMode.ESCAPE_JS_VALUE) {
            switch (this.state) {
                case JS_SQ_STRING: 
                case JS_DQ_STRING: 
                case CSS_SQ_STRING: 
                case CSS_DQ_STRING: {
                    return false;
                }
            }
            return true;
        }
        return this.delimType != AttributeEndDelimiter.SPACE_OR_TAG_END || escapingMode != EscapingMode.ESCAPE_HTML && escapingMode != EscapingMode.ESCAPE_HTML_ATTRIBUTE && escapingMode != EscapingMode.ESCAPE_HTML_RCDATA;
    }

    public boolean isErrorContext() {
        return this.state == State.ERROR;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Context)) {
            return false;
        }
        Context context = (Context)object;
        return this.state == context.state && this.elType == context.elType && this.attrType == context.attrType && this.delimType == context.delimType && this.slashType == context.slashType && this.uriPart == context.uriPart;
    }

    public int hashCode() {
        return this.packedBits();
    }

    public int packedBits() {
        return (((this.uriPart.ordinal() << 2 | this.slashType.ordinal() << 2 | this.delimType.ordinal()) << 3 | this.attrType.ordinal()) << 3 | this.elType.ordinal()) << 5 | this.state.ordinal();
    }

    public static Context union(Context context, Context context2) {
        if (context.equals(context2)) {
            return context;
        }
        if (context.equals(context2.derive(context.slashType))) {
            return context.derive(JsFollowingSlash.UNKNOWN);
        }
        if (context.equals(context2.derive(context.uriPart))) {
            return context.derive(context.uriPart != UriPart.FRAGMENT && context2.uriPart != UriPart.FRAGMENT && context.uriPart != UriPart.UNKNOWN && context2.uriPart != UriPart.UNKNOWN ? UriPart.UNKNOWN_PRE_FRAGMENT : UriPart.UNKNOWN);
        }
        if (context.state.compareTo(context2.state) > 0) {
            Context context3 = context;
            context = context2;
            context2 = context3;
        }
        if (context.state == State.HTML_TAG_NAME && context2.state == State.HTML_TAG) {
            return context2;
        }
        if (context.state == State.HTML_TAG && context.elType == context2.elType && (context2.state == State.HTML_ATTRIBUTE_NAME || context2.delimType == AttributeEndDelimiter.SPACE_OR_TAG_END)) {
            return context;
        }
        return ERROR;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(Context ").append(this.state.name());
        if (this.elType != ElementType.NONE) {
            stringBuilder.append(' ').append(this.elType.name());
        }
        if (this.attrType != AttributeType.NONE) {
            stringBuilder.append(' ').append(this.attrType.name());
        }
        if (this.delimType != AttributeEndDelimiter.NONE) {
            stringBuilder.append(' ').append(this.delimType.name());
        }
        if (this.slashType != JsFollowingSlash.NONE) {
            stringBuilder.append(' ').append(this.slashType.name());
        }
        if (this.uriPart != UriPart.NONE) {
            stringBuilder.append(' ').append(this.uriPart.name());
        }
        return stringBuilder.append(')').toString();
    }

    static {
        if (32 < State.values().length || 8 < ElementType.values().length || 8 < AttributeType.values().length || 4 < AttributeEndDelimiter.values().length || 4 < JsFollowingSlash.values().length || 8 < UriPart.values().length) {
            throw new AssertionError();
        }
    }

    public static enum UriPart {
        NONE,
        START,
        PRE_QUERY,
        QUERY,
        FRAGMENT,
        UNKNOWN_PRE_FRAGMENT,
        UNKNOWN;

    }

    public static enum JsFollowingSlash {
        NONE,
        REGEX,
        DIV_OP,
        UNKNOWN;

    }

    public static enum AttributeEndDelimiter {
        NONE,
        DOUBLE_QUOTE("\""),
        SINGLE_QUOTE("'"),
        SPACE_OR_TAG_END("");

        @Nullable
        public final String text;

        private AttributeEndDelimiter(String string2) {
            this.text = string2;
        }

        private AttributeEndDelimiter() {
            this.text = null;
        }
    }

    public static enum AttributeType {
        NONE,
        SCRIPT,
        STYLE,
        URI,
        PLAIN_TEXT;

    }

    public static enum ElementType {
        NONE,
        SCRIPT,
        STYLE,
        TEXTAREA,
        TITLE,
        LISTING,
        XMP,
        NORMAL;

    }

    public static enum State {
        HTML_PCDATA(EscapingMode.ESCAPE_HTML),
        HTML_RCDATA(EscapingMode.ESCAPE_HTML_RCDATA),
        HTML_BEFORE_TAG_NAME(EscapingMode.FILTER_HTML_ELEMENT_NAME),
        HTML_TAG_NAME(EscapingMode.FILTER_HTML_ELEMENT_NAME),
        HTML_TAG(EscapingMode.FILTER_HTML_ATTRIBUTE),
        HTML_ATTRIBUTE_NAME(EscapingMode.FILTER_HTML_ATTRIBUTE),
        HTML_BEFORE_ATTRIBUTE_VALUE,
        HTML_COMMENT(EscapingMode.ESCAPE_HTML_RCDATA),
        HTML_NORMAL_ATTR_VALUE(EscapingMode.ESCAPE_HTML_ATTRIBUTE),
        CSS(EscapingMode.FILTER_CSS_VALUE),
        CSS_COMMENT,
        CSS_DQ_STRING(EscapingMode.ESCAPE_CSS_STRING),
        CSS_SQ_STRING(EscapingMode.ESCAPE_CSS_STRING),
        CSS_URI(EscapingMode.NORMALIZE_URI),
        CSS_DQ_URI(EscapingMode.NORMALIZE_URI),
        CSS_SQ_URI(EscapingMode.NORMALIZE_URI),
        JS(EscapingMode.ESCAPE_JS_VALUE),
        JS_LINE_COMMENT,
        JS_BLOCK_COMMENT,
        JS_DQ_STRING(EscapingMode.ESCAPE_JS_STRING),
        JS_SQ_STRING(EscapingMode.ESCAPE_JS_STRING),
        JS_REGEX(EscapingMode.ESCAPE_JS_REGEX),
        URI(EscapingMode.ESCAPE_HTML_ATTRIBUTE),
        ERROR;

        @Nullable
        private final EscapingMode escapingMode;

        private State(EscapingMode escapingMode) {
            this.escapingMode = escapingMode;
        }

        private State() {
            this.escapingMode = null;
        }
    }
}

