/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SanitizedContent;
import java.util.Map;
import javax.annotation.Nullable;

public enum EscapingMode {
    ESCAPE_HTML(true, SanitizedContent.ContentKind.HTML),
    ESCAPE_HTML_RCDATA(true, null),
    ESCAPE_HTML_ATTRIBUTE(true, null),
    ESCAPE_HTML_ATTRIBUTE_NOSPACE(true, null),
    FILTER_HTML_ELEMENT_NAME(true, null),
    FILTER_HTML_ATTRIBUTE(true, null),
    ESCAPE_JS_STRING(false, SanitizedContent.ContentKind.JS_STR_CHARS),
    ESCAPE_JS_VALUE(false, null),
    ESCAPE_JS_REGEX(false, null),
    ESCAPE_CSS_STRING(true, null),
    FILTER_CSS_VALUE(false, null),
    ESCAPE_URI(true, SanitizedContent.ContentKind.URI),
    NORMALIZE_URI(false, SanitizedContent.ContentKind.URI),
    FILTER_NORMALIZE_URI(false, SanitizedContent.ContentKind.URI),
    NO_AUTOESCAPE(false, null);

    public final String directiveName = "|" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    public final boolean isHtmlEmbeddable;
    @Nullable
    public final SanitizedContent.ContentKind contentKind;
    private static final Map<String, EscapingMode> DIRECTIVE_TO_ESCAPING_MODE;

    private EscapingMode(boolean bl, SanitizedContent.ContentKind contentKind) {
        this.isHtmlEmbeddable = bl;
        this.contentKind = contentKind;
    }

    @Nullable
    public static EscapingMode fromDirective(String string) {
        return DIRECTIVE_TO_ESCAPING_MODE.get(string);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EscapingMode escapingMode : EscapingMode.values()) {
            builder.put((Object)escapingMode.directiveName, (Object)escapingMode);
        }
        DIRECTIVE_TO_ESCAPING_MODE = builder.build();
    }
}

