/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

final class JsUtil {
    private static final Set<String> REGEX_PRECEDER_KEYWORDS = ImmutableSet.of((Object)"break", (Object)"case", (Object)"continue", (Object)"delete", (Object)"do", (Object)"else", (Object[])new String[]{"finally", "instanceof", "return", "throw", "try", "typeof"});

    public static boolean isRegexPreceder(String string) {
        int n;
        int n2 = string.length();
        char c = string.charAt(n2 - 1);
        switch (c) {
            case '#': 
            case '%': 
            case '&': 
            case '(': 
            case '*': 
            case ',': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case '^': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
            case '+': 
            case '-': {
                int n3;
                for (n3 = n2 - 1; n3 > 0 && string.charAt(n3 - 1) == c; --n3) {
                }
                int n4 = n2 - n3;
                return (n4 & 1) == 1;
            }
            case '.': {
                if (n2 == 1) {
                    return true;
                }
                char c2 = string.charAt(n2 - 2);
                return '0' > c2 || c2 > '9';
            }
        }
        for (n = n2; n > 0 && Character.isJavaIdentifierPart(string.charAt(n - 1)); --n) {
        }
        return REGEX_PRECEDER_KEYWORDS.contains(string.substring(n));
    }

    private JsUtil() {
    }
}

